/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.danwi.sqlex.core.DaoFactory;
import me.danwi.sqlex.core.annotation.repository.SqlExSchema;
import me.danwi.sqlex.core.exception.SqlExException;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.exception.SqlExMigrationException;
import me.danwi.sqlex.core.migration.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DaoFactory daoFactory;
    private final Migration[] migrations;

    public Migrator(DaoFactory factory) {
        SqlExSchema[] schemas = (SqlExSchema[])factory.getRepositoryClass().getAnnotationsByType(SqlExSchema.class);
        this.migrations = new Migration[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            SqlExSchema schema = schemas[i];
            int version = schema.version();
            if (version >= schemas.length) {
                throw new SqlExImpossibleException("\u7248\u672c\u53f7\u5fc5\u987b\u4ece0\u5f00\u59cb,\u4e14\u8fde\u7eed");
            }
            if (this.migrations[version] != null) {
                throw new SqlExImpossibleException("\u7248\u672c\u53f7\u91cd\u590d,\u7248\u672c" + i + "\u5df2\u7ecf\u5b58\u5728");
            }
            this.migrations[version] = new Migration(version, schema.scripts());
        }
        this.daoFactory = factory;
    }

    private void execute(Connection connection, String sql) {
        try (Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException ex) {
            throw new SqlExMigrationException(ex);
        }
    }

    public int migrate() {
        return this.migrate(this.migrations.length - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int migrate(int version) {
        int n;
        Connection lockConnection;
        String rootPackage = this.daoFactory.getRepositoryClass().getPackage().getName();
        this.logger.info("\u51c6\u5907\u5c06\u6570\u636e\u5e93({})\u8fc1\u79fb\u5230 {} \u7248\u672c", (Object)rootPackage, (Object)version);
        try (Connection connection = this.daoFactory.newConnection();){
            this.execute(connection, "create table if not exists _sqlex_version_(package text not null, version int not null, can_migrate bool not null)");
        }
        catch (SQLException ex) {
            throw new SqlExMigrationException(ex);
        }
        boolean originAutoCommit = false;
        try {
            lockConnection = this.daoFactory.newConnection();
            if (lockConnection.getAutoCommit()) {
                lockConnection.setAutoCommit(false);
                originAutoCommit = true;
            }
            this.execute(lockConnection, "lock tables _sqlex_version_ write");
            this.logger.info("\u83b7\u53d6\u5230\u5168\u5c40\u9501,\u51c6\u5907\u5f00\u59cb\u8fc1\u79fb");
        }
        catch (SQLException ex) {
            throw new SqlExMigrationException(ex);
        }
        try {
            boolean hasVersion = false;
            int migratedVersion = -1;
            boolean canMigrate = false;
            try (PreparedStatement getVersionStatement = lockConnection.prepareStatement("select version,can_migrate from _sqlex_version_ where package=? for update");){
                getVersionStatement.setString(1, rootPackage);
                try (ResultSet resultSet = getVersionStatement.executeQuery();){
                    if (resultSet.next()) {
                        hasVersion = true;
                        migratedVersion = resultSet.getInt(1);
                        canMigrate = resultSet.getBoolean(2);
                    }
                }
            }
            if (!hasVersion) {
                this.execute(lockConnection, "insert into _sqlex_version_ values('" + rootPackage + "', -1, true)");
                canMigrate = true;
            }
            if (!canMigrate) {
                throw new SqlExMigrationException("\u5f53\u524d\u72b6\u6001\u4e3a\u65e0\u6cd5\u6267\u884c\u8fc1\u79fb,\u53ef\u80fd\u662f\u4e0a\u6b21\u7684\u8fc1\u79fb\u6ca1\u6709\u6210\u529f\u5b8c\u6210,\u9700\u8981\u4eba\u5de5\u4ecb\u5165");
            }
            if (version == migratedVersion) {
                this.logger.info("\u6570\u636e\u5e93\u5f53\u524d\u7248\u672c\u5df2\u7ecf\u662f {},\u65e0\u9700\u8fc1\u79fb", (Object)migratedVersion);
                int getVersionStatement = migratedVersion;
                return getVersionStatement;
            }
            this.logger.info("\u5f53\u524d\u6570\u636e\u5e93\u7248\u672c {}, \u7248\u672c\u5dee\u5f02 {}", (Object)migratedVersion, (Object)(version - migratedVersion));
            if (version <= migratedVersion || version >= this.migrations.length) {
                throw new SqlExMigrationException("\u9519\u8bef\u7684\u7248\u672c\u53f7,\u5f53\u524d\u7248\u672c\u8303\u56f4" + migratedVersion + "<version<=" + (this.migrations.length - 1));
            }
            this.execute(lockConnection, "update _sqlex_version_ set can_migrate=false where package='" + rootPackage + "'");
            for (int currentVersion = migratedVersion + 1; currentVersion <= version; ++currentVersion) {
                String[] sqls;
                this.logger.info("+ \u6b63\u5728\u6267\u884c {} \u7248\u672c\u7684\u8fc1\u79fb\u4efb\u52a1", (Object)currentVersion);
                Migration migration = this.migrations[currentVersion];
                for (String sql : sqls = migration.getScripts()) {
                    this.doMigrate(currentVersion, sql);
                }
                this.logger.info("+ {} \u7248\u672c\u8fc1\u79fb\u6210\u529f", (Object)currentVersion);
            }
            this.execute(lockConnection, "update _sqlex_version_ set can_migrate=true,version=" + version + " where package='" + rootPackage + "'");
            n = version;
        }
        catch (Exception ex) {
            this.execute(lockConnection, "update _sqlex_version_ set can_migrate=false where package='" + rootPackage + "'");
            if (ex instanceof SqlExMigrationException) {
                throw (SqlExMigrationException)ex;
            }
            throw new SqlExMigrationException(ex);
        }
        finally {
            try {
                try {
                    lockConnection.commit();
                }
                finally {
                    this.execute(lockConnection, "unlock tables");
                    this.logger.info("\u6570\u636e\u5e93({})\u7248\u672c\u8fc1\u79fb\u5b8c\u6210,\u91ca\u653e\u5168\u5c40\u9501", (Object)rootPackage);
                }
                if (originAutoCommit) {
                    lockConnection.setAutoCommit(false);
                }
                lockConnection.close();
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    private void doMigrate(int version, String sql) {
        try (Connection connection = this.daoFactory.newConnection();){
            this.logger.info("| \t{}", (Object)sql);
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
            }
        }
        catch (SqlExException e) {
            throw new SqlExMigrationException(version, e.getCause());
        }
        catch (SQLException e) {
            throw new SqlExMigrationException(version, (Throwable)e);
        }
    }
}

