/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.danwi.sqlex.common.StringUtils;
import me.danwi.sqlex.core.annotation.method.SqlExScript;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExInExprPosition;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExIsNullExprPosition;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExMarkerPosition;
import me.danwi.sqlex.core.annotation.method.parameter.SqlExParameterPosition;
import me.danwi.sqlex.core.invoke.method.MethodProxy;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;

public abstract class BaseMethodProxy
implements MethodProxy {
    private final String sql;
    private final MarkerInfo[] markerInfos;
    protected final RawSQLExecutor executor;

    public BaseMethodProxy(Method method, RawSQLExecutor executor) {
        this.executor = executor;
        this.sql = method.getAnnotation(SqlExScript.class).value();
        int[] markerPositions = method.getAnnotation(SqlExMarkerPosition.class).value();
        int[] parameterPositions = method.getAnnotation(SqlExParameterPosition.class).value();
        SqlExInExprPosition[] inExprPositions = (SqlExInExprPosition[])method.getAnnotationsByType(SqlExInExprPosition.class);
        SqlExIsNullExprPosition[] isNullExprPositions = (SqlExIsNullExprPosition[])method.getAnnotationsByType(SqlExIsNullExprPosition.class);
        this.markerInfos = new MarkerInfo[markerPositions.length];
        for (int index = 0; index < markerPositions.length; ++index) {
            MarkerInfo markerInfo = new MarkerInfo();
            int sqlIndex = markerPositions[index];
            for (SqlExInExprPosition sqlExInExprPosition : inExprPositions) {
                if (sqlExInExprPosition.marker() != sqlIndex) continue;
                markerInfo.inExprPosition = sqlExInExprPosition;
                break;
            }
            for (Annotation annotation : isNullExprPositions) {
                if (annotation.marker() != sqlIndex) continue;
                markerInfo.isNullExprPosition = annotation;
                break;
            }
            markerInfo.argIndex = parameterPositions[index];
            this.markerInfos[index] = markerInfo;
        }
    }

    protected List<Object> reorderArgs(Object[] methodArgs) {
        ArrayList<Object> reorderArgs = new ArrayList<Object>(this.markerInfos.length);
        for (MarkerInfo markerInfo : this.markerInfos) {
            Object methodArg = methodArgs[markerInfo.argIndex];
            if (markerInfo.inExprPosition != null) {
                if (methodArg == null) continue;
                if (methodArg instanceof List) {
                    List listArg = (List)methodArg;
                    if (listArg.size() == 0) continue;
                    reorderArgs.addAll(listArg);
                    continue;
                }
                reorderArgs.add(methodArg);
                continue;
            }
            if (markerInfo.isNullExprPosition != null) continue;
            reorderArgs.add(methodArg);
        }
        return reorderArgs;
    }

    protected String rewriteSQL(Object[] methodArgs) {
        LinkedList<StringUtils.ReplaceInfo> replaces = new LinkedList<StringUtils.ReplaceInfo>();
        for (MarkerInfo markerInfo : this.markerInfos) {
            Object methodArg = methodArgs[markerInfo.argIndex];
            if (markerInfo.inExprPosition != null) {
                if (methodArg == null) {
                    replaces.add(new StringUtils.ReplaceInfo(markerInfo.inExprPosition.start(), markerInfo.inExprPosition.end(), markerInfo.inExprPosition.not() ? "1=1" : "1=2"));
                } else if (methodArg instanceof List) {
                    List listArg = (List)methodArg;
                    if (listArg.size() == 0) {
                        replaces.add(new StringUtils.ReplaceInfo(markerInfo.inExprPosition.start(), markerInfo.inExprPosition.end(), markerInfo.inExprPosition.not() ? "1=1" : "1=2"));
                    } else {
                        String markerPart = listArg.stream().map(it -> "?").collect(Collectors.joining(","));
                        replaces.add(new StringUtils.ReplaceInfo(markerInfo.inExprPosition.marker(), markerInfo.inExprPosition.marker() + 1, markerPart));
                    }
                }
            }
            if (markerInfo.isNullExprPosition == null) continue;
            boolean argIsNull = methodArg == null;
            boolean sqlIsNull = !markerInfo.isNullExprPosition.not();
            replaces.add(new StringUtils.ReplaceInfo(markerInfo.isNullExprPosition.start(), markerInfo.isNullExprPosition.end(), argIsNull == sqlIsNull ? "1=1" : "1=2"));
        }
        return StringUtils.replace(this.sql, replaces);
    }

    private static class MarkerInfo {
        public int argIndex;
        public SqlExInExprPosition inExprPosition;
        public SqlExIsNullExprPosition isNullExprPosition;

        private MarkerInfo() {
        }
    }
}

