/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.common;

import java.util.List;
import java.util.Objects;

public class StringUtils {
    public static String replace(String text, List<ReplaceInfo> replaces) {
        StringBuilder result = new StringBuilder(text);
        for (ReplaceInfo replace : replaces) {
            result.replace(replace.start, replace.end, replace.content);
            int sizeGrow = replace.content.length() - (replace.end - replace.start);
            replaces.forEach(r -> {
                if (((ReplaceInfo)r).start >= replace.end) {
                    ((ReplaceInfo)r).start += sizeGrow;
                    ((ReplaceInfo)r).end += sizeGrow;
                }
            });
        }
        return result.toString();
    }

    public static class ReplaceInfo {
        private int start;
        private int end;
        private String content;

        public ReplaceInfo(int start, int end, String content) {
            this.start = start;
            this.end = end;
            this.content = content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplaceInfo that = (ReplaceInfo)o;
            return this.start == that.start && this.end == that.end && Objects.equals(this.content, that.content);
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end, this.content);
        }
    }
}

