/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.danwi.sqlex.common.SQLUtils;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.jdbc.ExecuteResult;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.jdbc.mapper.BasicTypeMapper;
import me.danwi.sqlex.core.jdbc.mapper.RowMapper;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;

public class RawSQLExecutor {
    private final TransactionManager transactionManager;
    private final Connection connection;
    private final ParameterSetter setter;
    private final ExceptionTranslator translator;
    private final Map<String, String> databaseNameMapping;

    public RawSQLExecutor(TransactionManager transactionManager, ParameterSetter setter, ExceptionTranslator translator, Map<String, String> databaseNameMapping) {
        this.transactionManager = transactionManager;
        this.connection = null;
        this.setter = setter;
        this.translator = translator;
        this.databaseNameMapping = databaseNameMapping;
    }

    public RawSQLExecutor(Connection connection, ParameterSetter setter, ExceptionTranslator translator, Map<String, String> databaseNameMapping) {
        this.transactionManager = null;
        this.connection = connection;
        this.setter = setter;
        this.translator = translator;
        this.databaseNameMapping = databaseNameMapping;
    }

    public long insert(String sql, Object ... parameters) {
        return this.execute(null, sql, Arrays.asList(parameters)).getAffectRows();
    }

    public <K> K insert(Class<K> generateKeyType, String sql, Object ... parameters) {
        return this.execute(generateKeyType, sql, Arrays.asList(parameters)).getGeneratedKey();
    }

    public long delete(String sql, Object ... parameters) {
        return this.execute(null, sql, Arrays.asList(parameters)).getAffectRows();
    }

    public long update(String sql, Object ... parameters) {
        return this.execute(null, sql, Arrays.asList(parameters)).getAffectRows();
    }

    public <T> List<T> select(Class<T> rowType, String sql, Object ... parameters) {
        return this.query(rowType, sql, Arrays.asList(parameters));
    }

    public long execute(String sql, Object ... parameters) {
        return this.execute(null, sql, Arrays.asList(parameters)).getAffectRows();
    }

    public <K> ExecuteResult<K> execute(Class<K> generateKeyType, String sql, List<Object> parameters) {
        Transaction currentTransaction = null;
        Connection connection = this.transactionManager != null ? ((currentTransaction = this.transactionManager.getCurrentTransaction()) != null ? currentTransaction.getConnection() : this.transactionManager.newConnection()) : this.connection;
        assert (connection != null);
        sql = SQLUtils.replaceDatabaseName(sql, this.databaseNameMapping);
        try {
            ExecuteResult<Object> executeResult;
            block27: {
                PreparedStatement statement = connection.prepareStatement(sql, 1);
                try {
                    this.setter.setParameters(statement, parameters);
                    long affectRows = 0L;
                    try {
                        affectRows = statement.executeLargeUpdate();
                    }
                    catch (UnsupportedOperationException e) {
                        affectRows = statement.executeUpdate();
                    }
                    Object generatedKey = null;
                    try (ResultSet rs = statement.getGeneratedKeys();){
                        BasicTypeMapper<K> mapper;
                        List<K> fetchResult;
                        if (generateKeyType != null && (fetchResult = (mapper = new BasicTypeMapper<K>(generateKeyType)).fetch(rs)).size() > 0) {
                            generatedKey = fetchResult.get(0);
                        }
                    }
                    executeResult = new ExecuteResult<Object>(affectRows, generatedKey);
                    if (statement == null) break block27;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw this.translator.translate(e);
                    }
                }
                statement.close();
            }
            return executeResult;
        }
        finally {
            if (this.transactionManager != null && currentTransaction == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw this.translator.translate(e);
                }
            }
        }
    }

    public <T> List<T> query(Class<T> rowType, String sql, Object ... parameters) {
        return this.query(null, rowType, sql, Arrays.asList(parameters));
    }

    public <T> List<T> query(RowMapper<T> rowMapper, String sql, Object ... parameters) {
        return this.query(rowMapper, null, sql, Arrays.asList(parameters));
    }

    /*
     * Exception decompiling
     */
    public <T> List<T> query(RowMapper<T> rowMapper, Class<T> rowType, String sql, List<Object> parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

