/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import me.danwi.sqlex.core.exception.SqlExException;
import me.danwi.sqlex.core.query.expression.Expression;

public class LiteralExpression
implements Expression {
    private final Object value;

    public LiteralExpression(Object value) {
        if (value instanceof Expression) {
            throw new SqlExException("\u5df2\u7ecf\u662f\u4e00\u4e2a\u8868\u8fbe\u5f0f\u4e86,\u65e0\u9700\u8f6c\u6362\u6210\u5b57\u9762\u91cf");
        }
        this.value = value;
    }

    @Override
    public String toSQL() {
        if (this.value instanceof Boolean || this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long || this.value instanceof Float || this.value instanceof Double || this.value instanceof BigInteger || this.value instanceof BigDecimal) {
            return this.value.toString();
        }
        if (this.value instanceof Character || this.value instanceof String) {
            String literal = this.value.toString().replace("'", "\\'");
            return "'" + literal + "'";
        }
        if (this.value instanceof Date || this.value instanceof LocalDate) {
            return String.format("DATE'%s'", this.value);
        }
        if (this.value instanceof Time || this.value instanceof LocalTime) {
            return String.format("TIME'%s'", this.value);
        }
        if (this.value instanceof Timestamp) {
            Timestamp time = (Timestamp)this.value;
            long second = time.getTime() / 1000L;
            long ms = time.getTime() - second * 1000L;
            return String.format("FROM_UNIXTIME(%d.%06d)", second, ms * 1000L);
        }
        if (this.value instanceof java.util.Date) {
            java.util.Date time = (java.util.Date)this.value;
            long second = time.getTime() / 1000L;
            long ms = time.getTime() - second * 1000L;
            return String.format("FROM_UNIXTIME(%d.%06d)", second, ms * 1000L);
        }
        if (this.value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)this.value;
            String date = localDateTime.toLocalDate().toString();
            String time = localDateTime.toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS"));
            return String.format("TIMESTAMP('%s %s')", date, time);
        }
        if (this.value instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)this.value;
            Timestamp timestamp = Timestamp.from(offsetDateTime.toInstant());
            long second = timestamp.getTime() / 1000L;
            long ms = timestamp.getTime() - second * 1000L;
            return String.format("FROM_UNIXTIME(%d.%06d)", second, ms * 1000L);
        }
        if (this.value instanceof ZonedDateTime) {
            ZonedDateTime offsetDateTime = (ZonedDateTime)this.value;
            Timestamp timestamp = Timestamp.from(offsetDateTime.toInstant());
            long second = timestamp.getTime() / 1000L;
            long ms = timestamp.getTime() - second * 1000L;
            return String.format("FROM_UNIXTIME(%d.%06d)", second, ms * 1000L);
        }
        throw new SqlExException("\u4e0d\u652f\u6301\u7684\u5b57\u9762\u91cf\u7c7b\u578b");
    }
}

