/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.common;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.LinkedList;
import java.util.Map;

public class SQLUtils {
    public static String replaceDatabaseName(String sql, final Map<String, String> mapping) {
        final boolean[] isReplaced = new boolean[]{false};
        SQLStatement sqlStatement = com.alibaba.druid.sql.SQLUtils.parseSingleMysqlStatement((String)sql);
        final LinkedList databaseNames = new LinkedList();
        sqlStatement.accept((SQLASTVisitor)new MySqlASTVisitor(){

            public boolean visit(SQLExprTableSource table) {
                String databaseName = table.getSchema();
                if (databaseName != null) {
                    String actualDatabaseName = (String)mapping.get(databaseName);
                    if (actualDatabaseName != null) {
                        table.setSchema(actualDatabaseName);
                        isReplaced[0] = true;
                    }
                    databaseNames.add(databaseName);
                }
                return false;
            }
        });
        sqlStatement.accept((SQLASTVisitor)new MySqlASTVisitor(){

            public boolean visit(SQLPropertyExpr x) {
                SQLExpr databaseExpr;
                SQLExpr tableExpr = x.getOwner();
                if (tableExpr != null && tableExpr instanceof SQLPropertyExpr && (databaseExpr = ((SQLPropertyExpr)tableExpr).getOwner()) != null && databaseExpr instanceof SQLIdentifierExpr) {
                    String actualDatabaseName;
                    String databaseName = ((SQLIdentifierExpr)databaseExpr).getName();
                    if (databaseNames.stream().anyMatch(it -> it.equals(databaseName)) && (actualDatabaseName = (String)mapping.get(databaseName)) != null) {
                        ((SQLIdentifierExpr)databaseExpr).setName(actualDatabaseName);
                        isReplaced[0] = true;
                    }
                }
                return false;
            }
        });
        if (!isReplaced[0]) {
            return sql;
        }
        return sqlStatement.toString();
    }
}

