/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke.method;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import me.danwi.sqlex.core.annotation.method.SqlExOneColumn;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.invoke.method.BaseMethodProxy;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;
import me.danwi.sqlex.core.jdbc.mapper.BasicTypeMapper;
import me.danwi.sqlex.core.jdbc.mapper.BeanMapper;
import me.danwi.sqlex.core.jdbc.mapper.RowMapper;

public class SelectMethodProxy
extends BaseMethodProxy {
    private final RowMapper<?> rowMapper;

    public SelectMethodProxy(Method method, RawSQLExecutor executor) {
        super(method, executor);
        Class<?> entityType = this.getEntityType(method);
        if (entityType == null) {
            throw new SqlExImpossibleException("\u65e0\u6cd5\u786e\u5b9a\u8fd4\u56de\u503c\u7c7b\u578b");
        }
        this.rowMapper = method.getAnnotation(SqlExOneColumn.class) != null ? new BasicTypeMapper(entityType) : new BeanMapper(entityType);
    }

    protected Class<?> getEntityType(Method method) {
        Type[] actualTypeArguments;
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments()) != null && actualTypeArguments.length == 1 && actualTypeArguments[0] instanceof Class) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    protected RowMapper<?> getRowMapper() {
        return this.rowMapper;
    }

    @Override
    public Object invoke(Object[] args) {
        return this.executor.query(this.getRowMapper(), null, this.rewriteSQL(args), this.reorderArgs(args));
    }
}

