/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.jdbc.mapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.List;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;

public abstract class RowMapper<T> {
    protected <C> C fetchColumn(ResultSet resultSet, int columnIndex, Class<C> dataType) throws SQLException {
        Object value;
        if (dataType.isArray()) {
            Class<?> elementType = dataType.getComponentType();
            if (elementType != null && elementType.isPrimitive() && elementType.getSimpleName().equals("byte")) {
                return (C)resultSet.getBytes(columnIndex);
            }
            throw new SqlExImpossibleException("\u7ed3\u679c\u7c7b\u4e2d\u5305\u542b\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b: " + dataType);
        }
        if (Boolean.class.equals(dataType)) {
            value = resultSet.getBoolean(columnIndex);
        } else if (Integer.class.equals(dataType)) {
            value = resultSet.getInt(columnIndex);
        } else if (Long.class.equals(dataType)) {
            value = resultSet.getLong(columnIndex);
        } else if (Float.class.equals(dataType)) {
            value = Float.valueOf(resultSet.getFloat(columnIndex));
        } else if (Double.class.equals(dataType)) {
            value = resultSet.getDouble(columnIndex);
        } else if (BigDecimal.class.equals(dataType)) {
            value = resultSet.getBigDecimal(columnIndex);
        } else if (BigInteger.class.equals(dataType)) {
            BigDecimal decimal = resultSet.getBigDecimal(columnIndex);
            value = decimal == null ? null : decimal.toBigInteger();
        } else if (String.class.equals(dataType)) {
            value = resultSet.getString(columnIndex);
        } else if (LocalDate.class.equals(dataType)) {
            value = resultSet.getObject(columnIndex, LocalDate.class);
        } else if (LocalTime.class.equals(dataType)) {
            value = resultSet.getObject(columnIndex, LocalTime.class);
        } else if (LocalDateTime.class.equals(dataType)) {
            value = resultSet.getObject(columnIndex, LocalDateTime.class);
        } else if (OffsetDateTime.class.equals(dataType)) {
            value = resultSet.getObject(columnIndex, OffsetDateTime.class);
        } else {
            throw new SqlExImpossibleException("\u7ed3\u679c\u7c7b\u4e2d\u5305\u542b\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b: " + dataType);
        }
        if (resultSet.wasNull()) {
            value = null;
        }
        return (C)value;
    }

    public abstract List<T> fetch(ResultSet var1) throws SQLException;
}

