/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.stream.Collectors;
import me.danwi.sqlex.core.annotation.entity.SqlExColumnName;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;
import me.danwi.sqlex.core.query.InsertOption;
import org.jetbrains.annotations.Nullable;

public class TableInsert<T, K> {
    private final String tableName;
    private final RawSQLExecutor executor;
    private final Class<K> generatedColumnJavaType;

    public TableInsert(String tableName, RawSQLExecutor executor, Class<K> generatedColumnJavaType) {
        this.tableName = tableName;
        this.executor = executor;
        this.generatedColumnJavaType = generatedColumnJavaType;
    }

    @Nullable
    public K insert(T entity, int options) {
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<Object> parameters = new LinkedList<Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = Introspector.getBeanInfo(entity.getClass()).getPropertyDescriptors()) {
                SqlExColumnName columnNameAnnotation;
                Method readMethod = property.getReadMethod();
                if (readMethod == null || (columnNameAnnotation = readMethod.getAnnotation(SqlExColumnName.class)) == null) continue;
                Object value = readMethod.invoke(entity, new Object[0]);
                if ((options & InsertOption.NULL_IS_NONE) == InsertOption.NULL_IS_NONE && value == null) continue;
                columnNames.add(columnNameAnnotation.value());
                parameters.add(value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new SqlExImpossibleException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7684\u5c5e\u6027/\u5217\u4fe1\u606f", e);
        }
        String sql = String.format("insert into `%s`(%s) values(%s)", this.tableName, columnNames.stream().map(name -> "`" + name + "`").collect(Collectors.joining(", ")), columnNames.stream().map(it -> "?").collect(Collectors.joining(", ")));
        if ((options & InsertOption.INSERT_OR_UPDATE) == InsertOption.INSERT_OR_UPDATE) {
            sql = sql + " on duplicate key update " + columnNames.stream().map(it -> String.format("`%s` = values(`%s`)", it, it)).collect(Collectors.joining(","));
        }
        return this.executor.execute(this.generatedColumnJavaType, sql, parameters).getGeneratedKey();
    }

    @Nullable
    public K insert(T entity) {
        return this.insert(entity, InsertOption.NONE_OPTIONS);
    }

    @Nullable
    public K insertWithoutNull(T entity) {
        return this.insert(entity, InsertOption.NULL_IS_NONE);
    }

    @Nullable
    public K upsert(T entity) {
        return this.insert(entity, InsertOption.INSERT_OR_UPDATE);
    }

    @Nullable
    public K upsertWithoutNull(T entity) {
        return this.insert(entity, InsertOption.NULL_IS_NONE | InsertOption.INSERT_OR_UPDATE);
    }
}

