/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;
import me.danwi.sqlex.core.query.SQLParameterBind;
import me.danwi.sqlex.core.query.WhereBuilder;
import me.danwi.sqlex.core.query.expression.Expression;
import me.danwi.sqlex.core.query.expression.ExpressionUtil;

public class TableUpdate<T>
extends WhereBuilder<T> {
    private final String tableName;
    private final RawSQLExecutor executor;
    protected Map<String, Object> values = new HashMap<String, Object>();

    public TableUpdate(String tableName, RawSQLExecutor executor) {
        this.tableName = tableName;
        this.executor = executor;
    }

    private SQLParameterBind buildSQL() {
        String sql = "update `" + this.tableName + "` set ";
        LinkedList<Object> parameters = new LinkedList<Object>();
        LinkedList<String> setSegments = new LinkedList<String>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            String columnName = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Expression) {
                SQLParameterBind sqlParameterBind = ExpressionUtil.toSQL((Expression)value);
                parameters.addAll(sqlParameterBind.getParameters());
                setSegments.add(String.format("`%s` = %s", columnName, sqlParameterBind.getSQL()));
                continue;
            }
            parameters.add(value);
            setSegments.add(String.format("`%s` = ?", columnName));
        }
        sql = sql + " " + String.join((CharSequence)", ", setSegments);
        if (this.whereCondition != null) {
            SQLParameterBind sqlParameterBind = ExpressionUtil.toSQL(this.whereCondition);
            sql = sql + " where " + sqlParameterBind.getSQL();
            parameters.addAll(sqlParameterBind.getParameters());
        }
        return new SQLParameterBind(sql, parameters);
    }

    public long execute() {
        if (this.values.size() == 0) {
            return 0L;
        }
        SQLParameterBind sqlParameterBind = this.buildSQL();
        return this.executor.execute(null, sqlParameterBind.getSQL(), sqlParameterBind.getParameters()).getAffectRows();
    }
}

