/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query.expression;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import me.danwi.sqlex.core.query.expression.BinaryExpression;
import me.danwi.sqlex.core.query.expression.CastExpression;
import me.danwi.sqlex.core.query.expression.FunctionCallExpression;
import me.danwi.sqlex.core.query.expression.InExpression;
import me.danwi.sqlex.core.query.expression.IsNullExpression;
import me.danwi.sqlex.core.query.expression.LikeExpression;
import me.danwi.sqlex.core.query.expression.LiteralExpression;
import me.danwi.sqlex.core.query.expression.NotExpression;
import me.danwi.sqlex.core.query.expression.ParameterExpression;
import me.danwi.sqlex.core.query.expression.RawExpression;

public interface Expression {
    public String toSQL();

    public static ParameterExpression arg(Object value) {
        return new ParameterExpression(value);
    }

    public static LiteralExpression lit(Object value) {
        return new LiteralExpression(value);
    }

    public static CastExpression cast(Expression expression, CastExpression.Type type) {
        return new CastExpression(expression, type);
    }

    public static CastExpression cast(Expression expression, CastExpression.Type type, long length) {
        return new CastExpression(expression, type, length);
    }

    public static CastExpression cast(Expression expression, CastExpression.Type type, long precision, long scale) {
        return new CastExpression(expression, type, precision, scale);
    }

    public static FunctionCallExpression func(String name, Expression ... args) {
        return new FunctionCallExpression(name, Arrays.asList(args));
    }

    public static RawExpression sql(String rawSQL) {
        return new RawExpression(rawSQL);
    }

    public static NotExpression not(Expression exp) {
        return new NotExpression(exp);
    }

    default public BinaryExpression and(Expression right) {
        return new BinaryExpression("and", this, right);
    }

    default public BinaryExpression or(Expression right) {
        return new BinaryExpression("or", this, right);
    }

    default public BinaryExpression eq(Expression right) {
        return new BinaryExpression("=", this, right);
    }

    default public BinaryExpression ne(Expression right) {
        return new BinaryExpression("<>", this, right);
    }

    default public BinaryExpression gt(Expression right) {
        return new BinaryExpression(">", this, right);
    }

    default public BinaryExpression gte(Expression right) {
        return new BinaryExpression(">=", this, right);
    }

    default public BinaryExpression lt(Expression right) {
        return new BinaryExpression("<", this, right);
    }

    default public BinaryExpression lte(Expression right) {
        return new BinaryExpression("<=", this, right);
    }

    default public InExpression in(Iterable<Expression> set) {
        return new InExpression(this, set);
    }

    default public NotExpression notIn(Iterable<Expression> set) {
        return Expression.not(this.in(set));
    }

    default public LikeExpression like(Expression right) {
        return new LikeExpression(this, right);
    }

    default public NotExpression notLike(Expression right) {
        return Expression.not(this.like(right));
    }

    default public IsNullExpression isNull() {
        return new IsNullExpression(this);
    }

    default public NotExpression isNotNull() {
        return Expression.not(this.isNull());
    }

    default public BinaryExpression add(Expression right) {
        return new BinaryExpression("+", this, right);
    }

    default public BinaryExpression sub(Expression right) {
        return new BinaryExpression("-", this, right);
    }

    default public BinaryExpression mul(Expression right) {
        return new BinaryExpression("*", this, right);
    }

    default public BinaryExpression div(Expression right) {
        return new BinaryExpression("/", this, right);
    }

    public static FunctionCallExpression now() {
        return Expression.func("now", new Expression[0]);
    }

    public static FunctionCallExpression currentTimestamp() {
        return Expression.func("current_timestamp", new Expression[0]);
    }

    public static FunctionCallExpression dateFormat(Expression date, Expression format) {
        return Expression.func("date_format", date, format);
    }

    public static FunctionCallExpression dateFormat(Expression date, String format) {
        return Expression.func("date_format", date, Expression.lit(format));
    }

    public static Expression joinByAnd(Iterable<Expression> expressions) {
        Iterator<Expression> iterator = expressions.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Expression accumulator = iterator.next();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            if (expression == null) continue;
            accumulator = accumulator.and(expression);
        }
        return accumulator;
    }

    public static Expression joinByOr(Iterable<Expression> expressions) {
        Iterator<Expression> iterator = expressions.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Expression accumulator = iterator.next();
        while (iterator.hasNext()) {
            Expression expression = iterator.next();
            if (expression == null) continue;
            accumulator = accumulator.or(expression);
        }
        return accumulator;
    }

    public static FunctionCallExpression concat(Expression ... param) {
        return Expression.func("concat", param);
    }

    public static FunctionCallExpression concatWs(LiteralExpression expression, Expression ... param) {
        List<Expression> list = Arrays.stream(param).collect(Collectors.toList());
        list.add(0, expression);
        return new FunctionCallExpression("concat_ws", list);
    }
}

