/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;

public class DefaultTransactionManager
implements TransactionManager {
    private final DataSource dataSource;
    private final ExceptionTranslator exceptionTranslator;
    private Integer defaultIsolationLevel;
    private final ThreadLocal<Transaction> threadLocal = new ThreadLocal();

    public DefaultTransactionManager(DataSource dataSource, ExceptionTranslator translator) {
        this.dataSource = dataSource;
        this.exceptionTranslator = translator;
    }

    public DefaultTransactionManager(DataSource dataSource, int defaultIsolationLevel, ExceptionTranslator translator) {
        this.dataSource = dataSource;
        this.defaultIsolationLevel = defaultIsolationLevel;
        this.exceptionTranslator = translator;
    }

    @Override
    public Integer getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.threadLocal.get();
    }

    @Override
    public Transaction newTransaction(Integer transactionIsolationLevel) {
        Connection connection = this.newConnection();
        DefaultTransaction defaultTransaction = new DefaultTransaction(connection, transactionIsolationLevel);
        this.threadLocal.set(defaultTransaction);
        return defaultTransaction;
    }

    @Override
    public Connection newConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw this.exceptionTranslator.translate(e);
        }
    }

    public class DefaultTransaction
    implements Transaction {
        private final Connection connection;
        private final boolean originAutoCommit;
        private Integer originIsolationLevel = Integer.MIN_VALUE;
        private final Integer desiredIsolationLevel;

        public DefaultTransaction(Connection connection, Integer desiredIsolationLevel) {
            try {
                this.connection = connection;
                this.desiredIsolationLevel = desiredIsolationLevel;
                if (desiredIsolationLevel != null) {
                    this.originIsolationLevel = connection.getTransactionIsolation();
                    if (!this.originIsolationLevel.equals(desiredIsolationLevel)) {
                        connection.setTransactionIsolation(desiredIsolationLevel);
                    }
                }
                this.originAutoCommit = connection.getAutoCommit();
                if (this.originAutoCommit) {
                    connection.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                throw DefaultTransactionManager.this.exceptionTranslator.translate(e);
            }
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public void commit() {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw DefaultTransactionManager.this.exceptionTranslator.translate(e);
            }
        }

        @Override
        public void rollback() {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw DefaultTransactionManager.this.exceptionTranslator.translate(e);
            }
        }

        @Override
        public void close() {
            try {
                if (this.connection.isClosed()) {
                    return;
                }
                if (this.desiredIsolationLevel != null && !this.originIsolationLevel.equals(this.desiredIsolationLevel)) {
                    this.connection.setTransactionIsolation(this.originIsolationLevel);
                }
                if (this.originAutoCommit) {
                    this.connection.setAutoCommit(true);
                }
                this.connection.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                DefaultTransactionManager.this.threadLocal.remove();
            }
        }
    }
}

