/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.danwi.sqlex.common.StringUtils;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.core.ParseASTNode;
import org.apache.shardingsphere.sql.parser.core.SQLParserFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.mysql.parser.MySQLParserFacade;

public class SQLUtils {
    private static final MySQLParserFacade mysqlParserFacade = new MySQLParserFacade();
    private static final Cache<String, String> replaceCache = CacheBuilder.newBuilder().maximumSize(500L).build();

    public static String replaceDatabaseName(String sql, Map<String, String> mapping) {
        String key = sql + "." + mapping.hashCode();
        String result = (String)replaceCache.getIfPresent((Object)key);
        if (result == null) {
            ParseASTNode ast = SQLUtils.parse(sql);
            DatabaseNameVisitor databaseNameVisitor = new DatabaseNameVisitor(mapping);
            ast.getRootNode().accept((ParseTreeVisitor)databaseNameVisitor);
            result = StringUtils.replace(sql, new ArrayList<StringUtils.ReplaceInfo>(databaseNameVisitor.replaces));
            replaceCache.put((Object)key, (Object)result);
        }
        return result;
    }

    public static List<String> splitStatements(String script) {
        script = script.trim();
        LinkedList<String> result = new LinkedList<String>();
        while (true) {
            ParseASTNode ast;
            if (!((ast = SQLUtils.parse(script)).getRootNode() instanceof ParserRuleContext) || ast.getRootNode().getParent() == null || !(ast.getRootNode().getParent() instanceof ParserRuleContext)) {
                continue;
            }
            result.add(script.substring(((ParserRuleContext)ast.getRootNode()).getStart().getStartIndex(), ((ParserRuleContext)ast.getRootNode()).getStop().getStopIndex() + 1));
            ParserRuleContext ctx = (ParserRuleContext)ast.getRootNode().getParent();
            if (ctx.getStop().getStopIndex() + 1 >= script.length()) break;
            script = script.substring(ctx.getStop().getStopIndex() + 1);
        }
        return result;
    }

    private static ParseASTNode parse(String sql) {
        ParseASTNode result = SQLUtils.twoPhaseParse(sql);
        if (result.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException("Unsupported SQL of `%s`", new Object[]{sql});
        }
        return result;
    }

    private static ParseASTNode twoPhaseParse(String sql) {
        SQLParser sqlParser = SQLParserFactory.newInstance((String)sql, (Class)mysqlParserFacade.getLexerClass(), (Class)mysqlParserFacade.getParserClass());
        try {
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.SLL);
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException var7) {
            ((Parser)sqlParser).reset();
            ((ParserATNSimulator)((Parser)sqlParser).getInterpreter()).setPredictionMode(PredictionMode.LL);
            try {
                return (ParseASTNode)sqlParser.parse();
            }
            catch (ParseCancellationException var6) {
                throw new SQLParsingException("You have an error in your SQL syntax");
            }
        }
    }

    private static class DatabaseNameVisitor
    extends AbstractParseTreeVisitor<Object> {
        private final Map<String, String> mapping;
        private final Set<StringUtils.ReplaceInfo> replaces = new HashSet<StringUtils.ReplaceInfo>();

        DatabaseNameVisitor(Map<String, String> mapping) {
            this.mapping = mapping;
        }

        public Object visit(ParseTree tree) {
            if (tree instanceof ParserRuleContext) {
                this.visit((ParserRuleContext)tree);
            }
            return super.visit(tree);
        }

        public Object visitChildren(RuleNode node) {
            if (node instanceof ParserRuleContext) {
                this.visit((ParserRuleContext)node);
            }
            return super.visitChildren(node);
        }

        public void visit(ParserRuleContext ctx) {
            MySQLStatementParser.IdentifierContext schemaID;
            String databaseName;
            MySQLStatementParser.ColumnRefContext columnRefContext;
            List identifiers;
            if (ctx instanceof MySQLStatementParser.TableFactorContext) {
                MySQLStatementParser.OwnerContext owner;
                String databaseName2;
                MySQLStatementParser.TableFactorContext tableFactorContext = (MySQLStatementParser.TableFactorContext)ctx;
                if (tableFactorContext.tableName() != null && tableFactorContext.tableName().owner() != null && (databaseName2 = this.mapping.get((owner = tableFactorContext.tableName().owner()).getText())) != null) {
                    this.replaces.add(new StringUtils.ReplaceInfo(owner.getStart().getStartIndex(), owner.getStop().getStopIndex() + 1, databaseName2));
                }
            } else if (ctx instanceof MySQLStatementParser.ColumnRefContext && (identifiers = (columnRefContext = (MySQLStatementParser.ColumnRefContext)ctx).identifier()).size() == 3 && (databaseName = this.mapping.get((schemaID = (MySQLStatementParser.IdentifierContext)identifiers.get(0)).getText())) != null) {
                this.replaces.add(new StringUtils.ReplaceInfo(schemaID.getStart().getStartIndex(), schemaID.getStop().getStopIndex() + 1, databaseName));
            }
        }
    }
}

