/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.spring;

import java.util.Map;
import me.danwi.sqlex.core.annotation.repository.SqlExMethods;
import me.danwi.sqlex.core.annotation.repository.SqlExTables;
import me.danwi.sqlex.spring.ImportSqlEx;
import me.danwi.sqlex.spring.SqlExFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class SqlExImportRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        SqlExTables tablesAnnotation;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(ImportSqlEx.class.getName()));
        assert (attributes != null);
        Class repository = attributes.getClass("value");
        String factoryName = attributes.getString("factoryName");
        SqlExMethods methodsAnnotation = repository.getAnnotation(SqlExMethods.class);
        if (methodsAnnotation != null) {
            Class<?>[] daoMethods;
            for (Class<?> daoMethod : daoMethods = methodsAnnotation.value()) {
                this.registerBeanDefinition(registry, daoMethod, factoryName);
            }
        }
        if ((tablesAnnotation = repository.getAnnotation(SqlExTables.class)) != null) {
            Class<?>[] tableClasses;
            for (Class<?> tableClass : tableClasses = tablesAnnotation.value()) {
                this.registerBeanDefinition(registry, tableClass, factoryName);
            }
        }
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, Class<?> clazz, String factoryName) {
        AbstractBeanDefinition definition = BeanDefinitionBuilder.genericBeanDefinition(SqlExFactoryBean.class).getBeanDefinition();
        definition.getConstructorArgumentValues().addGenericArgumentValue((Object)clazz.getName());
        if (StringUtils.hasText((String)factoryName)) {
            definition.getPropertyValues().addPropertyValue("factory", (Object)new RuntimeBeanReference(factoryName));
        }
        definition.setAttribute("factoryBeanObjectType", (Object)clazz.getName());
        definition.setAutowireMode(2);
        definition.setRole(2);
        definition.setAutowireCandidate(true);
        definition.setLazyInit(false);
        registry.registerBeanDefinition(clazz.getName(), (BeanDefinition)definition);
    }
}

