/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query.expression;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import me.danwi.sqlex.core.query.SQLParameterBind;
import me.danwi.sqlex.core.query.expression.Expression;

public class ExpressionUtil {
    private static final ThreadLocal<Map<String, Object>> parameterContext = new ThreadLocal();

    public static String getParameterPlaceholder(Object value) {
        int id;
        String placeholder;
        Map<String, Object> parameterContext = ExpressionUtil.parameterContext.get();
        if (parameterContext == null) {
            parameterContext = new HashMap<String, Object>();
            ExpressionUtil.parameterContext.set(parameterContext);
        }
        do {
            id = new Random().nextInt(900000) + 100000;
        } while (parameterContext.containsKey(placeholder = "#Parameter#{" + id + "}"));
        parameterContext.put(placeholder, value);
        return placeholder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLParameterBind toSQL(Expression expression) {
        try {
            String sql = expression.toSQL();
            LinkedList<Object> parameters = new LinkedList<Object>();
            Map<String, Object> context = parameterContext.get();
            if (context != null) {
                String tempSQL = sql;
                List placeholders = context.entrySet().stream().sorted(Comparator.comparing(it -> tempSQL.indexOf((String)it.getKey()))).collect(Collectors.toList());
                for (Map.Entry placeholder : placeholders) {
                    sql = sql.replace((CharSequence)placeholder.getKey(), "?");
                    parameters.add(placeholder.getValue());
                }
            }
            SQLParameterBind sQLParameterBind = new SQLParameterBind(sql, parameters);
            return sQLParameterBind;
        }
        finally {
            parameterContext.remove();
        }
    }
}

