/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.checker;

import com.mysql.cj.MysqlType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.danwi.sqlex.core.DaoFactory;
import me.danwi.sqlex.core.annotation.repository.SqlExTables;
import me.danwi.sqlex.core.checker.ColumnInfo;
import me.danwi.sqlex.core.checker.TableInfo;
import me.danwi.sqlex.core.exception.SqlExCheckException;
import me.danwi.sqlex.core.query.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    DaoFactory factory;

    public Checker(DaoFactory factory) {
        this.factory = factory;
    }

    public void check() {
        this.logger.info("\u51c6\u5907\u6bd4\u5bf9\u6570\u636e\u5e93\u7ed3\u6784\u4e00\u81f4\u6027");
        this.logger.info("\u83b7\u53d6SqlEx Repository({})\u5b9a\u4e49\u7ed3\u6784", (Object)this.factory.getRepositoryClass().getPackage().getName());
        List<TableInfo> repositoryTables = this.getRepositoryTables();
        this.logger.info("\u83b7\u53d6\u76ee\u6807\u6570\u636e\u5e93\u7ed3\u6784");
        List<TableInfo> databaseTables = this.getDatabaseTables();
        this.logger.info("\u8ba1\u7b97\u7ed3\u6784\u5dee\u5f02");
        List<TableInfo> diffTables = this.diff(repositoryTables, databaseTables);
        if (diffTables.size() != 0) {
            throw new SqlExCheckException(diffTables);
        }
        this.logger.info("\u7ed3\u6784\u4e00\u81f4\u6027\u6bd4\u5bf9\u5b8c\u6210,\u65e0\u5dee\u5f02");
    }

    private List<TableInfo> diff(List<TableInfo> source, List<TableInfo> target) {
        Map<String, Map<String, ColumnInfo>> sourceTables = this.toTableColumnMap(source);
        Map<String, Map<String, ColumnInfo>> targetTables = this.toTableColumnMap(target);
        ArrayList<TableInfo> diffTables = new ArrayList<TableInfo>();
        sourceTables.forEach((sourceTableName, sourceColumnMap) -> {
            Map targetColumnMap = (Map)targetTables.get(sourceTableName);
            if (targetColumnMap != null) {
                ArrayList<ColumnInfo> diffColumns = new ArrayList<ColumnInfo>();
                sourceColumnMap.forEach((sourceColumnName, sourceColumn) -> {
                    ColumnInfo targetColumn = (ColumnInfo)targetColumnMap.get(sourceColumnName);
                    if (targetColumn != null && sourceColumn.typeId == JDBCType.TINYINT && sourceColumn.length == 1L && targetColumn.typeId == JDBCType.BIT && targetColumn.length == 1L) {
                        return;
                    }
                    if (targetColumn == null || sourceColumn.typeId != targetColumn.typeId || sourceColumn.primaryKey != targetColumn.primaryKey) {
                        diffColumns.add((ColumnInfo)sourceColumn);
                    }
                });
                if (diffColumns.size() > 0) {
                    diffTables.add(new TableInfo((String)sourceTableName, (List<ColumnInfo>)diffColumns));
                }
            } else {
                diffTables.add(new TableInfo((String)sourceTableName, (List<ColumnInfo>)new ArrayList<ColumnInfo>(sourceColumnMap.values())));
            }
        });
        return diffTables;
    }

    private Map<String, Map<String, ColumnInfo>> toTableColumnMap(List<TableInfo> tables) {
        HashMap<String, Map<String, ColumnInfo>> map = new HashMap<String, Map<String, ColumnInfo>>();
        for (TableInfo table : tables) {
            HashMap<String, ColumnInfo> columnMap = new HashMap<String, ColumnInfo>();
            for (ColumnInfo column : table.columns) {
                columnMap.put(column.name, column);
            }
            map.put(table.name, columnMap);
        }
        return map;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<TableInfo> getDatabaseTables() {
        try (Connection conn = this.factory.newConnection();){
            ArrayList<TableInfo> arrayList;
            block30: {
                DatabaseMetaData databaseMetaData = conn.getMetaData();
                ResultSet tableResultSet = databaseMetaData.getTables(conn.getCatalog(), null, null, null);
                try {
                    ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
                    while (tableResultSet.next()) {
                        String tableName = tableResultSet.getString("TABLE_NAME");
                        ResultSet columnResultSet = databaseMetaData.getColumns(conn.getCatalog(), null, tableName, null);
                        try {
                            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
                            while (columnResultSet.next()) {
                                columns.add(new ColumnInfo(columnResultSet.getString("COLUMN_NAME"), JDBCType.valueOf(columnResultSet.getInt("DATA_TYPE")), MysqlType.getByJdbcType((int)columnResultSet.getInt("DATA_TYPE")).getName().toLowerCase(), columnResultSet.getInt("COLUMN_SIZE"), columnResultSet.getString("TYPE_NAME").contains("UNSIGNED")));
                            }
                            try (ResultSet primaryKeyResultSet = databaseMetaData.getPrimaryKeys(conn.getCatalog(), null, tableName);){
                                while (primaryKeyResultSet.next()) {
                                    String columnName = primaryKeyResultSet.getString("COLUMN_NAME");
                                    for (ColumnInfo c : columns) {
                                        if (!Objects.equals(c.name, columnName)) continue;
                                        c.setPrimaryKey(true);
                                    }
                                }
                            }
                            tables.add(new TableInfo(tableName, columns));
                        }
                        finally {
                            if (columnResultSet == null) continue;
                            columnResultSet.close();
                        }
                    }
                    arrayList = tables;
                    if (tableResultSet == null) break block30;
                }
                catch (Throwable throwable) {
                    if (tableResultSet != null) {
                        try {
                            tableResultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tableResultSet.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw this.factory.getExceptionTranslator().translate(e);
        }
    }

    private List<TableInfo> getRepositoryTables() {
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        for (Class<?> tableClass : this.factory.getRepositoryClass().getAnnotation(SqlExTables.class).value()) {
            ArrayList<ColumnInfo> columns = new ArrayList<ColumnInfo>();
            String tableName = "";
            for (Field field : tableClass.getFields()) {
                try {
                    Object instance = field.get(null);
                    if (!Modifier.isStatic(field.getModifiers()) || !(instance instanceof Column)) continue;
                    Column.MetaData metaData = ((Column)instance).getMetaData();
                    columns.add(new ColumnInfo(metaData.isPrimaryKey(), metaData.getColumnName(), metaData.getJdbcType(), metaData.getTypeName(), metaData.getLength(), metaData.isUnsigned()));
                    tableName = metaData.getTableName();
                }
                catch (Exception e) {
                    this.logger.warn("\u83b7\u53d6column\u4fe1\u606f\u5931\u8d25: {}", (Object)e.toString());
                }
            }
            tables.add(new TableInfo(tableName, columns));
        }
        return tables;
    }
}

