/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import me.danwi.sqlex.core.annotation.method.SqlExOneRow;
import me.danwi.sqlex.core.annotation.method.SqlExPaged;
import me.danwi.sqlex.core.annotation.method.type.SqlExDelete;
import me.danwi.sqlex.core.annotation.method.type.SqlExInsert;
import me.danwi.sqlex.core.annotation.method.type.SqlExSelect;
import me.danwi.sqlex.core.annotation.method.type.SqlExUpdate;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.invoke.method.InsertMethodProxy;
import me.danwi.sqlex.core.invoke.method.MethodProxy;
import me.danwi.sqlex.core.invoke.method.SelectMethodProxy;
import me.danwi.sqlex.core.invoke.method.SelectOneRowMethodProxy;
import me.danwi.sqlex.core.invoke.method.SelectPagedMethodProxy;
import me.danwi.sqlex.core.invoke.method.UpdateDeleteMethodProxy;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;

public class InvocationProxy
implements InvocationHandler {
    private final RawSQLExecutor executor;
    private final Map<Method, MethodProxy> methodProxyCache = new HashMap<Method, MethodProxy>();

    public InvocationProxy(RawSQLExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        MethodProxy methodProxy = this.methodProxyCache.get(method);
        if (methodProxy == null) {
            Map<Method, MethodProxy> map = this.methodProxyCache;
            synchronized (map) {
                methodProxy = this.methodProxyCache.get(method);
                if (methodProxy == null) {
                    if (method.getDeclaredAnnotation(SqlExSelect.class) != null) {
                        methodProxy = method.getDeclaredAnnotation(SqlExPaged.class) != null ? new SelectPagedMethodProxy(method, this.executor) : (method.getDeclaredAnnotation(SqlExOneRow.class) != null ? new SelectOneRowMethodProxy(method, this.executor) : new SelectMethodProxy(method, this.executor));
                    } else if (method.getAnnotation(SqlExInsert.class) != null) {
                        methodProxy = new InsertMethodProxy(method, this.executor);
                    } else if (method.getAnnotation(SqlExUpdate.class) != null || method.getAnnotation(SqlExDelete.class) != null) {
                        methodProxy = new UpdateDeleteMethodProxy(method, this.executor);
                    } else {
                        throw new SqlExImpossibleException("\u9519\u8bef\u7684\u65b9\u6cd5\u7c7b\u578b");
                    }
                    this.methodProxyCache.put(method, methodProxy);
                }
            }
        }
        return methodProxy.invoke(args);
    }
}

