/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.migration;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import me.danwi.sqlex.core.DaoFactory;
import me.danwi.sqlex.core.annotation.repository.SqlExSchema;
import me.danwi.sqlex.core.exception.SqlExException;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.exception.SqlExMigrationException;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;
import me.danwi.sqlex.core.migration.MigrateCallback;
import me.danwi.sqlex.core.migration.Migration;
import me.danwi.sqlex.core.migration.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DaoFactory daoFactory;
    private final Migration[] migrations;

    public Migrator(DaoFactory factory) {
        SqlExSchema[] schemas = (SqlExSchema[])factory.getRepositoryClass().getAnnotationsByType(SqlExSchema.class);
        this.migrations = new Migration[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            SqlExSchema schema = schemas[i];
            int version = schema.version();
            if (version >= schemas.length) {
                throw new SqlExImpossibleException("\u7248\u672c\u53f7\u5fc5\u987b\u4ece0\u5f00\u59cb,\u4e14\u8fde\u7eed");
            }
            if (this.migrations[version] != null) {
                throw new SqlExImpossibleException("\u7248\u672c\u53f7\u91cd\u590d,\u7248\u672c" + i + "\u5df2\u7ecf\u5b58\u5728");
            }
            this.migrations[version] = new Migration(version, schema.scripts());
        }
        this.daoFactory = factory;
    }

    public int migrate() {
        return this.migrate(null);
    }

    public int migrate(MigrateCallback callback) {
        return this.migrate(this.migrations.length - 1, callback);
    }

    public int migrate(int version) {
        return this.migrate(version, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int migrate(int version, MigrateCallback callback) {
        int n;
        RawSQLExecutor executor;
        String rootPackage = this.daoFactory.getRepositoryClass().getPackage().getName();
        this.logger.info("\u51c6\u5907\u5c06\u6570\u636e\u5e93({})\u8fc1\u79fb\u5230 {} \u7248\u672c", (Object)rootPackage, (Object)version);
        try {
            Connection connection = this.daoFactory.newConnection();
            executor = this.daoFactory.getRawSQLExecutor(connection);
            executor.execute("create table if not exists _sqlex_version_(package text not null, version int not null, can_migrate bool not null)", new Object[0]);
        }
        catch (Exception ex) {
            throw new SqlExMigrationException(ex);
        }
        Connection lockConnection = this.daoFactory.newConnection();
        executor = this.daoFactory.getRawSQLExecutor(lockConnection);
        boolean originAutoCommit = false;
        try {
            if (lockConnection.getAutoCommit()) {
                lockConnection.setAutoCommit(false);
                originAutoCommit = true;
            }
            executor.execute("lock tables _sqlex_version_ write", new Object[0]);
            this.logger.info("\u83b7\u53d6\u5230\u5168\u5c40\u9501,\u51c6\u5907\u5f00\u59cb\u8fc1\u79fb");
            VersionInfo versionInfo = null;
            List<VersionInfo> results = executor.query(VersionInfo.class, "select * from _sqlex_version_ where package=?", rootPackage);
            if (!results.isEmpty()) {
                versionInfo = results.get(0);
            }
            if (versionInfo == null) {
                executor.execute("insert into _sqlex_version_ values(?, -1, true)", rootPackage);
                versionInfo = new VersionInfo();
                versionInfo.setRootPackage(rootPackage);
                versionInfo.setVersion(-1);
                versionInfo.setCanMigrate(true);
            }
            if (!versionInfo.getCanMigrate().booleanValue()) {
                throw new SqlExMigrationException("\u5f53\u524d\u72b6\u6001\u4e3a\u65e0\u6cd5\u6267\u884c\u8fc1\u79fb,\u53ef\u80fd\u662f\u4e0a\u6b21\u7684\u8fc1\u79fb\u6ca1\u6709\u6210\u529f\u5b8c\u6210,\u9700\u8981\u4eba\u5de5\u4ecb\u5165");
            }
            if (version == versionInfo.getVersion()) {
                this.logger.info("\u6570\u636e\u5e93\u5f53\u524d\u7248\u672c\u5df2\u7ecf\u662f {},\u65e0\u9700\u8fc1\u79fb", (Object)versionInfo.getVersion());
                int n2 = versionInfo.getVersion();
                return n2;
            }
            this.logger.info("\u5f53\u524d\u6570\u636e\u5e93\u7248\u672c {}, \u7248\u672c\u5dee\u5f02 {}", (Object)versionInfo.getVersion(), (Object)(version - versionInfo.getVersion()));
            if (version <= versionInfo.getVersion() || version >= this.migrations.length) {
                throw new SqlExMigrationException("\u9519\u8bef\u7684\u7248\u672c\u53f7,\u5f53\u524d\u7248\u672c\u8303\u56f4" + versionInfo.getVersion() + "<version<=" + (this.migrations.length - 1));
            }
            executor.execute("update _sqlex_version_ set can_migrate=false where package=?", rootPackage);
            for (int currentVersion = versionInfo.getVersion() + 1; currentVersion <= version; ++currentVersion) {
                String[] sqls;
                this.logger.info("+ \u6b63\u5728\u6267\u884c {} \u7248\u672c\u7684\u8fc1\u79fb\u4efb\u52a1", (Object)currentVersion);
                if (callback != null) {
                    Connection migrateConnection = this.daoFactory.newConnection();
                    boolean connectionAutoCommit = false;
                    try {
                        if (migrateConnection.getAutoCommit()) {
                            migrateConnection.setAutoCommit(false);
                            connectionAutoCommit = true;
                        }
                        callback.before(currentVersion, this.daoFactory.getRawSQLExecutor(migrateConnection));
                        migrateConnection.commit();
                    }
                    catch (Exception e) {
                        migrateConnection.rollback();
                        throw e;
                    }
                    finally {
                        if (connectionAutoCommit) {
                            migrateConnection.setAutoCommit(false);
                        }
                        migrateConnection.close();
                    }
                }
                Migration migration = this.migrations[currentVersion];
                for (String sql : sqls = migration.getScripts()) {
                    this.doMigrate(currentVersion, sql);
                }
                executor.execute("update _sqlex_version_ set version=? where package=?", currentVersion, rootPackage);
                if (callback != null) {
                    Connection migrateConnection = this.daoFactory.newConnection();
                    boolean connectionAutoCommit = false;
                    try {
                        if (migrateConnection.getAutoCommit()) {
                            migrateConnection.setAutoCommit(false);
                            connectionAutoCommit = true;
                        }
                        callback.after(currentVersion, this.daoFactory.getRawSQLExecutor(migrateConnection));
                        migrateConnection.commit();
                    }
                    catch (Exception e) {
                        migrateConnection.rollback();
                        throw e;
                    }
                    finally {
                        if (connectionAutoCommit) {
                            migrateConnection.setAutoCommit(false);
                        }
                        migrateConnection.close();
                    }
                }
                this.logger.info("+ {} \u7248\u672c\u8fc1\u79fb\u6210\u529f", (Object)currentVersion);
            }
            executor.execute("update _sqlex_version_ set can_migrate=true where package=?", rootPackage);
            n = version;
        }
        catch (Exception ex) {
            executor.execute("update _sqlex_version_ set can_migrate=false where package=?", rootPackage);
            if (ex instanceof SqlExMigrationException) {
                throw (SqlExMigrationException)ex;
            }
            throw new SqlExMigrationException(ex);
        }
        finally {
            try {
                try {
                    lockConnection.commit();
                }
                finally {
                    executor.execute("unlock tables", new Object[0]);
                    this.logger.info("\u6570\u636e\u5e93({})\u7248\u672c\u8fc1\u79fb\u5b8c\u6210,\u91ca\u653e\u5168\u5c40\u9501", (Object)rootPackage);
                }
                if (originAutoCommit) {
                    lockConnection.setAutoCommit(false);
                }
                lockConnection.close();
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    private void doMigrate(int version, String sql) {
        try (Connection connection = this.daoFactory.newConnection();){
            this.logger.info("| \t{}", (Object)sql);
            try (Statement statement = connection.createStatement();){
                statement.execute(sql);
            }
        }
        catch (SqlExException e) {
            throw new SqlExMigrationException(version, e.getCause());
        }
        catch (SQLException e) {
            throw new SqlExMigrationException(version, (Throwable)e);
        }
    }
}

