/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.migration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import me.danwi.sqlex.common.SQLUtils;
import me.danwi.sqlex.core.exception.SqlExException;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;
import me.danwi.sqlex.core.migration.MigrateCallback;
import me.danwi.sqlex.core.migration.VersionMigrateCallback;

public class SQLMigrateUtil {
    public static MigrateCallback before(int version, String script) {
        return VersionMigrateCallback.before(version, (RawSQLExecutor executor) -> {
            for (String statement : SQLUtils.splitStatements(script)) {
                executor.execute(statement, new Object[0]);
            }
        });
    }

    public static MigrateCallback after(int version, String script) {
        return VersionMigrateCallback.after(version, (RawSQLExecutor executor) -> {
            for (String statement : SQLUtils.splitStatements(script)) {
                executor.execute(statement, new Object[0]);
            }
        });
    }

    public static MigrateCallback before(int version, InputStream inputStream) {
        return SQLMigrateUtil.before(version, SQLMigrateUtil.readToString(inputStream));
    }

    public static MigrateCallback after(int version, InputStream inputStream) {
        String script = SQLMigrateUtil.readToString(inputStream);
        return SQLMigrateUtil.after(version, script);
    }

    public static MigrateCallback before(int version, URL url) {
        MigrateCallback migrateCallback;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                migrateCallback = SQLMigrateUtil.before(version, inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SqlExException("\u4eceURL\u4e2d\u83b7\u53d6\u7248\u672c\u8fc1\u79fb\u56de\u8c03\u811a\u672c\u6587\u4ef6\u6d41\u5f02\u5e38", e);
                }
            }
            inputStream.close();
        }
        return migrateCallback;
    }

    public static MigrateCallback after(int version, URL url) {
        MigrateCallback migrateCallback;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                migrateCallback = SQLMigrateUtil.after(version, inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SqlExException("\u4eceURL\u4e2d\u83b7\u53d6\u7248\u672c\u8fc1\u79fb\u56de\u8c03\u811a\u672c\u6587\u4ef6\u6d41\u5f02\u5e38", e);
                }
            }
            inputStream.close();
        }
        return migrateCallback;
    }

    public static MigrateCallback before(int version, File file) {
        return SQLMigrateUtil.before(version, SQLMigrateUtil.toScriptUrl(file));
    }

    public static MigrateCallback after(int version, File file) {
        return SQLMigrateUtil.after(version, SQLMigrateUtil.toScriptUrl(file));
    }

    public static MigrateCallback beforeForClassPath(int version, String path) {
        return SQLMigrateUtil.before(version, SQLMigrateUtil.class.getClassLoader().getResource(path));
    }

    public static MigrateCallback afterForClassPath(int version, String path) {
        return SQLMigrateUtil.after(version, SQLMigrateUtil.class.getClassLoader().getResource(path));
    }

    private static URL toScriptUrl(File file) {
        if (file.isDirectory()) {
            throw new SqlExException(file.getAbsolutePath() + " \u8be5\u8def\u5f84\u662f\u6587\u4ef6\u5939\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u7248\u672c\u8fc1\u79fb\u56de\u8c03\u811a\u672c");
        }
        if (!file.exists()) {
            throw new SqlExException(file.getAbsolutePath() + " \u8be5\u8def\u5f84\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3a\u7248\u672c\u8fc1\u79fb\u56de\u8c03\u811a\u672c");
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SqlExException("\u7248\u672c\u8fc1\u79fb\u56de\u8c03\u811a\u672c\u6587\u4ef6\u8f6c\u6362URL\u5f02\u5e38");
        }
    }

    private static String readToString(InputStream inputStream) {
        String string;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            string = result.toString("UTF-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    result.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SqlExException("\u7248\u672c\u8fc1\u79fb\u56de\u8c03\u811a\u672c\u6587\u4ef6\u8f6c\u6362\u5b57\u7b26\u4e32\u5f02\u5e38", e);
            }
        }
        result.close();
        return string;
    }
}

