/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;
import me.danwi.sqlex.core.jdbc.mapper.BasicTypeMapper;
import me.danwi.sqlex.core.jdbc.mapper.BeanMapper;
import me.danwi.sqlex.core.query.Order;
import me.danwi.sqlex.core.query.SQLParameterBind;
import me.danwi.sqlex.core.query.WhereBuilder;
import me.danwi.sqlex.core.query.expression.Expression;
import me.danwi.sqlex.core.query.expression.ExpressionUtil;
import me.danwi.sqlex.core.type.PagedResult;
import org.jetbrains.annotations.Nullable;

public class TableQuery<T>
extends WhereBuilder<TableQuery<T>> {
    private final String tableName;
    private final RawSQLExecutor executor;
    private final BeanMapper<T> beanMapper;
    private final List<OrderPair> orders = new ArrayList<OrderPair>();
    private Long skip;
    private Long take;
    private boolean forUpdate = false;

    public TableQuery(String tableName, RawSQLExecutor executor, Class<T> entityClass) {
        this.tableName = tableName;
        this.executor = executor;
        this.beanMapper = new BeanMapper<T>(entityClass);
    }

    public TableQuery<T> order(Expression exp) {
        return this.order(exp, Order.Asc);
    }

    public TableQuery<T> order(Expression exp, Order order) {
        OrderPair pair = new OrderPair();
        pair.expression = exp;
        pair.order = order;
        this.orders.add(pair);
        return this;
    }

    public TableQuery<T> skip(long number) {
        this.skip = number;
        return this;
    }

    public TableQuery<T> take(long number) {
        this.take = number;
        return this;
    }

    public TableQuery<T> forUpdate() {
        this.forUpdate = true;
        return this;
    }

    private SQLParameterBind buildSQL() {
        String sql = "select * from `" + this.tableName + "`";
        LinkedList<Object> parameters = new LinkedList<Object>();
        if (this.whereCondition != null) {
            SQLParameterBind sqlParameterBind = ExpressionUtil.toSQL(this.whereCondition);
            sql = sql + " where " + sqlParameterBind.getSQL();
            parameters.addAll(sqlParameterBind.getParameters());
        }
        if (!this.orders.isEmpty()) {
            sql = sql + " order by ";
            LinkedList<String> orderSegments = new LinkedList<String>();
            for (OrderPair order : this.orders) {
                SQLParameterBind sqlParameterBind = ExpressionUtil.toSQL(order.expression);
                orderSegments.add("(" + sqlParameterBind.getSQL() + ") " + (order.order == Order.Asc ? "asc" : "desc"));
                parameters.addAll(sqlParameterBind.getParameters());
            }
            sql = sql + String.join((CharSequence)", ", orderSegments);
        }
        if (this.skip != null && this.take != null) {
            sql = sql + String.format(" limit %d, %d", this.skip, this.take);
        } else if (this.skip != null) {
            sql = sql + String.format(" limit %d, 18446744073709551615", this.skip);
        } else if (this.take != null) {
            sql = sql + " limit " + this.take;
        }
        if (this.forUpdate) {
            sql = sql + " for update";
        }
        return new SQLParameterBind(sql, parameters);
    }

    public long count() {
        SQLParameterBind sqlParameterBind = this.buildSQL();
        String countSQL = "select count(1) from (" + sqlParameterBind.getSQL() + ") temp";
        return this.executor.query(new BasicTypeMapper<Long>(Long.class), null, countSQL, sqlParameterBind.getParameters()).get(0);
    }

    public List<T> find() {
        SQLParameterBind sqlParameterBind = this.buildSQL();
        return this.executor.query(this.beanMapper, null, sqlParameterBind.getSQL(), sqlParameterBind.getParameters());
    }

    @Nullable
    public T findOne() {
        List<T> results = this.take(1L).find();
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public PagedResult<T> page(long pageSize, long pageNo) {
        long total = this.count();
        this.skip(pageSize * (pageNo - 1L)).take(pageSize);
        List<T> data = this.find();
        return new PagedResult<T>(pageSize, pageNo, total, data);
    }

    private static class OrderPair {
        Expression expression;
        Order order;

        private OrderPair() {
        }
    }
}

