/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.common;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class LRUCache<K, V> {
    private final int size;
    private final Map<K, Data> cache;
    private final LinkedList<Data> list;

    public LRUCache(int size) {
        this.size = size;
        this.cache = new HashMap<K, Data>(size);
        this.list = new LinkedList();
    }

    public V get(K key) {
        if (this.cache.containsKey(key)) {
            Data data = this.cache.get(key);
            this.list.remove(data);
            this.list.addFirst(data);
            return data.value;
        }
        return null;
    }

    public void set(K key, V value) {
        if (this.cache.containsKey(key)) {
            Data oldData = this.cache.get(key);
            this.list.remove(oldData);
            Data newData = new Data(key, value);
            this.cache.put(key, newData);
            this.list.addFirst(newData);
        } else {
            Data toRemove;
            Data data = new Data(key, value);
            if (this.cache.size() >= this.size && (toRemove = this.list.pollLast()) != null) {
                this.cache.remove(toRemove.key);
            }
            this.cache.put(key, data);
            this.list.addFirst(data);
        }
    }

    private class Data {
        K key;
        V value;

        Data(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

