/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.jdbc.mapper;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import me.danwi.sqlex.core.annotation.entity.SqlExColumnName;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.jdbc.mapper.RowMapper;

public class BeanMapper<T>
extends RowMapper<T> {
    private final Class<T> beanClass;
    private final Constructor<T> beanConstructor;
    private PropertyInfo[] beanPropertyInfoCaches;

    public BeanMapper(Class<T> bean) {
        this.beanClass = bean;
        try {
            this.beanConstructor = this.beanClass.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new SqlExImpossibleException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b(" + this.beanClass.getName() + ")\u7684\u6784\u9020\u51fd\u6570");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyInfo[] getPropertyInfo(ResultSet resultSet) throws SQLException {
        PropertyInfo[] propertyInfo = this.beanPropertyInfoCaches;
        if (propertyInfo == null) {
            BeanMapper beanMapper = this;
            synchronized (beanMapper) {
                propertyInfo = this.beanPropertyInfoCaches;
                if (propertyInfo == null) {
                    PropertyDescriptor[] propertyDescriptors;
                    try {
                        propertyDescriptors = Introspector.getBeanInfo(this.beanClass).getPropertyDescriptors();
                    }
                    catch (IntrospectionException e) {
                        throw new SqlExImpossibleException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b(" + this.beanClass.getName() + ")\u7684\u5c5e\u6027");
                    }
                    propertyInfo = (PropertyInfo[])Arrays.stream(propertyDescriptors).map(p -> {
                        Method writeMethod = p.getWriteMethod();
                        if (writeMethod != null && p.getReadMethod() != null) {
                            SqlExColumnName columnNameAnnotation = writeMethod.getAnnotation(SqlExColumnName.class);
                            if (columnNameAnnotation != null) {
                                return new PropertyInfo(p.getName(), columnNameAnnotation.value(), writeMethod, p.getPropertyType());
                            }
                            return new PropertyInfo(p.getName(), p.getName(), writeMethod, p.getPropertyType());
                        }
                        return null;
                    }).filter(Objects::nonNull).toArray(PropertyInfo[]::new);
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    for (PropertyInfo property : propertyInfo) {
                        int colIndex;
                        for (colIndex = 1; colIndex <= metaData.getColumnCount(); ++colIndex) {
                            if (!property.columnName.equals(metaData.getColumnLabel(colIndex))) continue;
                            property.columnIndex = colIndex;
                            break;
                        }
                        for (colIndex = 1; colIndex <= metaData.getColumnCount(); ++colIndex) {
                            if (!property.columnName.equalsIgnoreCase(metaData.getColumnLabel(colIndex))) continue;
                            property.columnIndex = colIndex;
                            break;
                        }
                        if (property.columnIndex > 0) continue;
                        throw new SqlExImpossibleException("\u5b9e\u4f53\u7c7b " + this.beanClass.getSimpleName() + " \u7684 " + property.name + " \u5c5e\u6027\u65e0\u6cd5\u5728\u7ed3\u679c\u96c6\u4e2d\u627e\u5230\u5bf9\u5e94\u7684 " + property.columnName + " \u5217\u6570\u636e");
                    }
                    this.beanPropertyInfoCaches = propertyInfo;
                }
            }
        }
        return propertyInfo;
    }

    @Override
    public List<T> fetch(ResultSet resultSet) throws SQLException {
        LinkedList<T> resultList = new LinkedList<T>();
        PropertyInfo[] propertyInfos = this.getPropertyInfo(resultSet);
        while (resultSet.next()) {
            T beanInstance;
            try {
                beanInstance = this.beanConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SqlExImpossibleException("\u65e0\u6cd5\u521b\u5efa\u5b9e\u4f53\u7c7b(" + this.beanClass.getName() + ")\u7684\u5b9e\u4f8b");
            }
            for (PropertyInfo propertyInfo : propertyInfos) {
                int colIndex = propertyInfo.columnIndex;
                Object value = this.fetchColumn(resultSet, colIndex, propertyInfo.dataType);
                try {
                    propertyInfo.writeMethod.invoke(beanInstance, value);
                }
                catch (Exception e) {
                    throw new SqlExImpossibleException("\u65e0\u6cd5\u5411\u5b9e\u4f53\u7c7b(" + this.beanClass.getName() + ")\u4e2d\u5199\u5165\u5c5e\u6027(" + propertyInfo.name + ")\u7684\u503c");
                }
            }
            resultList.add(beanInstance);
        }
        return resultList;
    }

    private static class PropertyInfo {
        public String name;
        public String columnName;
        public int columnIndex;
        public Method writeMethod;
        public Class<?> dataType;

        public PropertyInfo(String name, String columnName, Method writeMethod, Class<?> dataType) {
            this.name = name;
            this.columnName = columnName;
            this.columnIndex = -1;
            this.writeMethod = writeMethod;
            this.dataType = dataType;
        }
    }
}

