/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.apt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import me.danwi.sqlex.core.annotation.SqlExConverterCheck;
import me.danwi.sqlex.core.apt.SqlExProcessorUtil;

public class SqlExConverterCheckAnnotationProcessor
extends AbstractProcessor {
    private SqlExProcessorUtil util;
    private Types typesUtil;
    private Elements elementsUtil;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.util = new SqlExProcessorUtil(processingEnv);
        this.typesUtil = processingEnv.getTypeUtils();
        this.elementsUtil = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add(SqlExConverterCheck.class.getName());
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> repositoryElements = roundEnv.getElementsAnnotatedWith(SqlExConverterCheck.class);
        for (Element element : repositoryElements) {
            if (!(element instanceof TypeElement)) continue;
            this.checkRepositoryInterface((TypeElement)element);
        }
        return true;
    }

    private void checkRepositoryInterface(TypeElement repositoryTypeElement) {
        try {
            List<TypeElement> allConverterElements = this.util.getAllParameterConverterElements(repositoryTypeElement);
            for (TypeElement converterElement : allConverterElements) {
                try {
                    this.util.isValidateParameterConverter(converterElement);
                }
                catch (Exception e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, this.util.getQualifiedName(converterElement) + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, this.util.getQualifiedName(repositoryTypeElement) + ": " + e.getMessage());
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

