/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.apt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import me.danwi.sqlex.common.ParameterTypes;
import me.danwi.sqlex.core.annotation.SqlExConverter;
import me.danwi.sqlex.core.type.ParameterConverter;

public class SqlExProcessorUtil {
    private final ProcessingEnvironment env;
    private final Types types;
    private final Elements elements;

    public SqlExProcessorUtil(ProcessingEnvironment env) {
        this.env = env;
        this.types = env.getTypeUtils();
        this.elements = env.getElementUtils();
    }

    public String getQualifiedName(TypeMirror type) {
        return this.getQualifiedName(this.types.asElement(type));
    }

    public String getQualifiedName(Element element) {
        if (element instanceof QualifiedNameable) {
            return ((QualifiedNameable)element).getQualifiedName().toString();
        }
        return element.toString();
    }

    public Element getSuperClass(TypeMirror type) {
        return this.getSuperClass(this.types.asElement(type));
    }

    public Element getSuperClass(Element element) {
        List<? extends TypeMirror> supertypes = this.types.directSupertypes(element.asType());
        if (supertypes.isEmpty()) {
            return null;
        }
        return this.types.asElement(supertypes.get(0));
    }

    public List<TypeElement> getAllParameterConverterElements(TypeElement element) throws Exception {
        SqlExConverter[] converters;
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        for (SqlExConverter converter : converters = (SqlExConverter[])element.getAnnotationsByType(SqlExConverter.class)) {
            TypeMirror typeMirror = null;
            try {
                converter.converter();
            }
            catch (MirroredTypeException e) {
                typeMirror = e.getTypeMirror();
            }
            if (typeMirror == null) {
                throw new Exception("\u7f16\u8bd1\u65f6\u65e0\u6cd5\u83b7\u53d6\u53c2\u6570\u8f6c\u5316\u5668\u4fe1\u606f");
            }
            Element converterElement = this.types.asElement(typeMirror);
            if (converterElement == null) {
                throw new Exception("\u7f16\u8bd1\u65f6\u65e0\u6cd5\u83b7\u53d6\u53c2\u6570\u8f6c\u6362\u5668\u7684\u7c7b\u578b\u4fe1\u606f");
            }
            if (!(converterElement instanceof TypeElement)) continue;
            result.add((TypeElement)converterElement);
        }
        return result;
    }

    public TypeMirror isValidateParameterConverter(TypeElement element) throws Exception {
        List declaredTypes = element.getInterfaces().stream().map(it -> {
            if (this.getQualifiedName((TypeMirror)it).contentEquals(ParameterConverter.class.getName()) && it instanceof DeclaredType) {
                return (DeclaredType)it;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (declaredTypes.size() == 0) {
            throw new Exception("\u672a\u5b9e\u73b0\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5668\u63a5\u53e3");
        }
        DeclaredType converterInterface = (DeclaredType)declaredTypes.get(0);
        if (element.getEnclosedElements().stream().filter(it -> it.getKind() == ElementKind.CONSTRUCTOR).map(it -> {
            if (it instanceof ExecutableElement) {
                return (ExecutableElement)it;
            }
            return null;
        }).filter(Objects::nonNull).noneMatch(it -> it.getParameters().size() == 0)) {
            throw new Exception("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5668\u5fc5\u987b\u5305\u542b\u4e00\u4e2a\u65e0\u53c2\u6784\u9020\u51fd\u6570");
        }
        List<? extends TypeMirror> typeArguments = converterInterface.getTypeArguments();
        if (typeArguments.size() != 2) {
            throw new Exception("\u8f6c\u6362\u5668\u63a5\u53e3\u62e5\u6709\u9519\u8bef\u7684\u6cdb\u578b\u53c2\u6570\u4e2a\u6570");
        }
        TypeMirror toType = typeArguments.get(1);
        if (!this.isSupportedType(this.types.asElement(toType), Collections.emptyList())) {
            throw new Exception("\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5668\u7684\u76ee\u6807\u7c7b\u578b " + this.getQualifiedName(toType) + " \u4e0d\u662f\u9884\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b");
        }
        TypeMirror typeMirror = typeArguments.get(0);
        if (typeMirror == null) {
            throw new Exception("\u65e0\u6cd5\u786e\u5b9a\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5668\u7684\u76ee\u6807\u7c7b\u578b");
        }
        return typeMirror;
    }

    public boolean isSupportedType(Element element, List<String> additional) {
        String qualifiedName = this.getQualifiedName(element);
        if (Arrays.asList(ParameterTypes.PreSupportedTypes).contains(qualifiedName)) {
            return true;
        }
        if (additional.contains(qualifiedName)) {
            return true;
        }
        Element superClass = this.getSuperClass(element);
        if (superClass == null) {
            return false;
        }
        return this.isSupportedType(superClass, additional);
    }
}

