/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke.method;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.invoke.method.SelectMethodProxy;
import me.danwi.sqlex.core.repository.ParameterConverterRegistry;
import me.danwi.sqlex.core.transaction.TransactionManager;
import me.danwi.sqlex.core.type.PagedResult;

public class SelectPagedMethodProxy
extends SelectMethodProxy {
    public SelectPagedMethodProxy(Method method, TransactionManager transactionManager, ParameterConverterRegistry registry, ExceptionTranslator translator) {
        super(method, transactionManager, registry, translator);
    }

    @Override
    protected Object invoke(Object[] args, Connection connection) throws SQLException {
        List<?> result;
        long total;
        Object[] argsWithoutPage = Arrays.copyOfRange(args, 0, args.length - 2);
        long pageSize = (Long)args[args.length - 2];
        long pageNo = (Long)args[args.length - 1];
        String sql = this.rewriteSQL(argsWithoutPage);
        String countSQL = "select count(1) from (" + sql + ") temp";
        try (PreparedStatement statement = connection.prepareStatement(countSQL);){
            List<Object> reorderArgs = this.reorderArgs(argsWithoutPage);
            this.setParameters(statement, reorderArgs);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) {
                    throw new SqlExImpossibleException("\u65e0\u6cd5\u83b7\u53d6\u5206\u9875\u603b\u884c\u6570");
                }
                total = rs.getLong(1);
            }
        }
        String pageSQL = "select * from (" + sql + ") temp limit " + pageSize + " offset " + pageSize * pageNo;
        try (PreparedStatement statement = connection.prepareStatement(pageSQL);){
            List<Object> reorderArgs = this.reorderArgs(argsWithoutPage);
            this.setParameters(statement, reorderArgs);
            try (ResultSet rs = statement.executeQuery();){
                result = this.getRowMapper().fetch(rs);
            }
        }
        return new PagedResult(pageSize, pageNo, total, result);
    }
}

