/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.repository;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import me.danwi.sqlex.core.RepositoryLike;
import me.danwi.sqlex.core.annotation.SqlExConverter;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.type.ParameterConverter;

public class ParameterConverterRegistry {
    private final Map<Class<?>, ParameterConverter<Object, Object>> parameterConverters;

    private ParameterConverterRegistry(Map<Class<?>, ParameterConverter<Object, Object>> parameterConverters) {
        this.parameterConverters = parameterConverters;
    }

    public static ParameterConverterRegistry fromRepository(Class<? extends RepositoryLike> repository) {
        SqlExConverter[] converterAnnotations;
        HashMap parameterConverters = new HashMap();
        for (SqlExConverter converterAnnotation : converterAnnotations = (SqlExConverter[])repository.getAnnotationsByType(SqlExConverter.class)) {
            Type[] converterInterfaces;
            Class<?> converter = converterAnnotation.converter();
            for (Type converterInterface : converterInterfaces = converter.getGenericInterfaces()) {
                Type[] typeArguments;
                ParameterizedType parameterizedType;
                if (!(converterInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)converterInterface).getRawType().getTypeName().equals(ParameterConverter.class.getTypeName()) || (typeArguments = parameterizedType.getActualTypeArguments()).length != 2 || !(typeArguments[0] instanceof Class)) continue;
                ParameterConverter instance = null;
                try {
                    instance = (ParameterConverter)converter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new SqlExImpossibleException("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5668");
                }
                parameterConverters.put((Class)typeArguments[0], instance);
            }
        }
        return new ParameterConverterRegistry(parameterConverters);
    }

    public ParameterConverter<Object, Object> getConverterFor(Object parameter) {
        for (Map.Entry<Class<?>, ParameterConverter<Object, Object>> converterEntry : this.parameterConverters.entrySet()) {
            if (!converterEntry.getKey().isInstance(parameter)) continue;
            return converterEntry.getValue();
        }
        return null;
    }
}

