/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.sql.JDBCType;
import me.danwi.sqlex.core.query.expression.Expression;

public class Column
implements Expression {
    private final MetaData metaData;

    public Column(String tableName, String columnName, String typeName, JDBCType jdbcType, long length, boolean unsigned, boolean binary, long decimal, boolean isPrimaryKey, boolean isAutoIncrement, boolean isUnique, boolean isNotNull, boolean hasDefaultValue) {
        this.metaData = new MetaData(tableName, columnName, typeName, jdbcType, length, unsigned, binary, decimal, isPrimaryKey, isAutoIncrement, isUnique, isNotNull, hasDefaultValue);
    }

    @Override
    public String toSQL() {
        return String.format("%s.%s", this.metaData.tableName, this.metaData.columnName);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public static class MetaData {
        private final String tableName;
        private final String columnName;
        private final String typeName;
        private final JDBCType jdbcType;
        private final long length;
        private final boolean unsigned;
        private final boolean binary;
        private final long decimal;
        private final boolean isPrimaryKey;
        private final boolean isAutoIncrement;
        private final boolean isUnique;
        private final boolean isNotNull;
        private final boolean hasDefaultValue;

        MetaData(String tableName, String columnName, String typeName, JDBCType jdbcType, long length, boolean unsigned, boolean binary, long decimal, boolean isPrimaryKey, boolean isAutoIncrement, boolean isUnique, boolean isNotNull, boolean hasDefaultValue) {
            this.tableName = tableName;
            this.columnName = columnName;
            this.typeName = typeName;
            this.jdbcType = jdbcType;
            this.length = length;
            this.unsigned = unsigned;
            this.binary = binary;
            this.decimal = decimal;
            this.isPrimaryKey = isPrimaryKey;
            this.isAutoIncrement = isAutoIncrement;
            this.isUnique = isUnique;
            this.isNotNull = isNotNull;
            this.hasDefaultValue = hasDefaultValue;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public JDBCType getJdbcType() {
            return this.jdbcType;
        }

        public long getLength() {
            return this.length;
        }

        public boolean isUnsigned() {
            return this.unsigned;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public long getDecimal() {
            return this.decimal;
        }

        public boolean isPrimaryKey() {
            return this.isPrimaryKey;
        }

        public boolean isAutoIncrement() {
            return this.isAutoIncrement;
        }

        public boolean isUnique() {
            return this.isUnique;
        }

        public boolean isNotNull() {
            return this.isNotNull;
        }

        public boolean isHasDefaultValue() {
            return this.hasDefaultValue;
        }
    }
}

