/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.query.SQLParameterBind;
import me.danwi.sqlex.core.query.WhereBuilder;
import me.danwi.sqlex.core.query.expression.ExpressionUtil;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;

public class TableDelete
extends WhereBuilder<TableDelete> {
    private final String tableName;
    private final TransactionManager transactionManager;
    private final ParameterSetter parameterSetter;
    private final ExceptionTranslator translator;

    public TableDelete(String tableName, TransactionManager transactionManager, ParameterSetter parameterSetter, ExceptionTranslator translator) {
        this.tableName = tableName;
        this.transactionManager = transactionManager;
        this.parameterSetter = parameterSetter;
        this.translator = translator;
    }

    private SQLParameterBind buildSQL() {
        String sql = "delete from " + this.tableName;
        LinkedList<Object> parameters = new LinkedList<Object>();
        if (this.whereCondition != null) {
            SQLParameterBind sqlParameterBind = ExpressionUtil.toSQL(this.whereCondition);
            sql = sql + " where " + sqlParameterBind.getSQL();
            parameters.addAll(sqlParameterBind.getParameters());
        }
        return new SQLParameterBind(sql, parameters);
    }

    /*
     * Loose catch block
     */
    public long execute() {
        Transaction currentTransaction = this.transactionManager.getCurrentTransaction();
        Connection connection = currentTransaction != null ? currentTransaction.getConnection() : this.transactionManager.newConnection();
        try {
            long l;
            PreparedStatement statement;
            block22: {
                SQLParameterBind sqlParameterBind = this.buildSQL();
                statement = connection.prepareStatement(sqlParameterBind.getSQL());
                this.parameterSetter.setParameters(statement, sqlParameterBind.getParameters());
                l = statement.executeLargeUpdate();
                if (statement == null) break block22;
                statement.close();
            }
            return l;
            {
                catch (UnsupportedOperationException e) {
                    long l2;
                    block24: {
                        block23: {
                            l2 = statement.executeUpdate();
                            if (statement == null) break block23;
                            statement.close();
                        }
                        if (currentTransaction != null) break block24;
                        try {
                            connection.close();
                        }
                        catch (SQLException e2) {
                            throw this.translator.translate(e2);
                        }
                    }
                    return l2;
                    {
                        catch (Throwable throwable) {
                            try {
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLException e3) {
                                throw this.translator.translate(e3);
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (currentTransaction == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw this.translator.translate(e);
                }
            }
        }
    }
}

