/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.stream.Collectors;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.annotation.entity.SqlExColumnName;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.jdbc.ParameterSetter;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;

public class TableInsert<T> {
    private final String tableName;
    private final TransactionManager transactionManager;
    private final ParameterSetter parameterSetter;
    private final ExceptionTranslator translator;
    public static int NONE_OPTIONS = 0;
    public static int NULL_IS_NONE = 1;
    public static int RETURN_GENERATE_KEY = 2;

    public TableInsert(String tableName, TransactionManager transactionManager, ParameterSetter parameterSetter, ExceptionTranslator translator) {
        this.tableName = tableName;
        this.transactionManager = transactionManager;
        this.parameterSetter = parameterSetter;
        this.translator = translator;
    }

    public T save(T entity, int options) {
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<Object> parameters = new LinkedList<Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = Introspector.getBeanInfo(entity.getClass()).getPropertyDescriptors()) {
                SqlExColumnName columnNameAnnotation;
                Method readMethod = property.getReadMethod();
                if (readMethod == null || (columnNameAnnotation = readMethod.getAnnotation(SqlExColumnName.class)) == null) continue;
                Object value = readMethod.invoke(entity, new Object[0]);
                if ((options & NULL_IS_NONE) == NULL_IS_NONE && value == null) continue;
                columnNames.add(columnNameAnnotation.value());
                parameters.add(value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new SqlExImpossibleException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7684\u5c5e\u6027/\u5217\u4fe1\u606f", e);
        }
        String sql = String.format("insert into %s(%s) values(%s)", this.tableName, String.join((CharSequence)", ", columnNames), columnNames.stream().map(it -> "?").collect(Collectors.joining(", ")));
        Transaction currentTransaction = this.transactionManager.getCurrentTransaction();
        Connection connection = currentTransaction != null ? currentTransaction.getConnection() : this.transactionManager.newConnection();
        try {
            T t;
            block19: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    this.parameterSetter.setParameters(statement, parameters);
                    statement.executeUpdate();
                    t = entity;
                    if (statement == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw this.translator.translate(e);
                    }
                }
                statement.close();
            }
            return t;
        }
        finally {
            if (currentTransaction == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw this.translator.translate(e);
                }
            }
        }
    }

    public T save(T entity) {
        return this.save(entity, NONE_OPTIONS);
    }

    public T saveWithoutNull(T entity) {
        return this.save(entity, NULL_IS_NONE);
    }
}

