/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.query.expression;

import java.util.Arrays;
import me.danwi.sqlex.core.query.expression.BinaryExpression;
import me.danwi.sqlex.core.query.expression.FunctionCallExpression;
import me.danwi.sqlex.core.query.expression.ParameterExpression;
import me.danwi.sqlex.core.query.expression.UnaryExpression;

public interface Expression {
    public String toSQL();

    public static FunctionCallExpression func(String name, Expression ... args) {
        return new FunctionCallExpression(name, Arrays.asList(args));
    }

    public static ParameterExpression arg(Object value) {
        return new ParameterExpression(value);
    }

    public static UnaryExpression not(Expression exp) {
        return new UnaryExpression("!", exp);
    }

    default public BinaryExpression and(Expression right) {
        return new BinaryExpression("and", this, right);
    }

    default public BinaryExpression or(Expression right) {
        return new BinaryExpression("or", this, right);
    }

    default public BinaryExpression eq(Expression right) {
        return new BinaryExpression("=", this, right);
    }

    default public BinaryExpression ne(Expression right) {
        return new BinaryExpression("<>", this, right);
    }

    default public BinaryExpression gt(Expression right) {
        return new BinaryExpression(">", this, right);
    }

    default public BinaryExpression gte(Expression right) {
        return new BinaryExpression(">=", this, right);
    }

    default public BinaryExpression lt(Expression right) {
        return new BinaryExpression("<", this, right);
    }

    default public BinaryExpression lte(Expression right) {
        return new BinaryExpression("<=", this, right);
    }

    default public BinaryExpression add(Expression right) {
        return new BinaryExpression("+", this, right);
    }

    default public BinaryExpression sub(Expression right) {
        return new BinaryExpression("-", this, right);
    }

    default public BinaryExpression mul(Expression right) {
        return new BinaryExpression("*", this, right);
    }

    default public BinaryExpression div(Expression right) {
        return new BinaryExpression("/", this, right);
    }

    default public BinaryExpression like(Expression right) {
        return new BinaryExpression("like", this, right);
    }
}

