/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke.mapper;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.List;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;

public abstract class RowMapper {
    protected Object fetchColumn(ResultSet resultSet, int columnIndex, Class<?> dataType) throws SQLException {
        return this.fetchColumn(resultSet, columnIndex, dataType.getName());
    }

    protected Object fetchColumn(ResultSet resultSet, int colIndex, String dataTypeName) throws SQLException {
        Object value;
        switch (dataTypeName) {
            case "java.lang.Boolean": {
                value = resultSet.getBoolean(colIndex);
                break;
            }
            case "java.lang.Integer": {
                value = resultSet.getInt(colIndex);
                break;
            }
            case "java.lang.Long": {
                value = resultSet.getLong(colIndex);
                break;
            }
            case "java.lang.Float": {
                value = Float.valueOf(resultSet.getFloat(colIndex));
                break;
            }
            case "java.lang.Double": {
                value = resultSet.getDouble(colIndex);
                break;
            }
            case "java.math.BigDecimal": {
                value = resultSet.getBigDecimal(colIndex);
                break;
            }
            case "java.math.BigInteger": {
                BigDecimal decimal = resultSet.getBigDecimal(colIndex);
                value = decimal == null ? null : decimal.toBigInteger();
                break;
            }
            case "java.lang.String": {
                value = resultSet.getString(colIndex);
                break;
            }
            case "java.time.LocalDate": {
                value = resultSet.getObject(colIndex, LocalDate.class);
                break;
            }
            case "java.time.LocalTime": {
                value = resultSet.getObject(colIndex, LocalTime.class);
                break;
            }
            case "java.time.LocalDateTime": {
                value = resultSet.getObject(colIndex, LocalDateTime.class);
                break;
            }
            case "java.time.OffsetDateTime": {
                value = resultSet.getObject(colIndex, OffsetDateTime.class);
                break;
            }
            default: {
                throw new SqlExImpossibleException("\u7ed3\u679c\u7c7b\u4e2d\u5305\u542b\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b: " + dataTypeName);
            }
        }
        if (resultSet.wasNull()) {
            value = null;
        }
        return value;
    }

    public abstract List<?> fetch(ResultSet var1) throws SQLException;
}

