/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.annotation.SqlExInExprPosition;
import me.danwi.sqlex.core.annotation.SqlExIsNullExprPosition;
import me.danwi.sqlex.core.annotation.SqlExMarkerPosition;
import me.danwi.sqlex.core.annotation.SqlExParameterPosition;
import me.danwi.sqlex.core.annotation.SqlExScript;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.invoke.method.MethodProxy;
import me.danwi.sqlex.core.repository.ParameterConverterRegistry;
import me.danwi.sqlex.core.transaction.Transaction;
import me.danwi.sqlex.core.transaction.TransactionManager;
import me.danwi.sqlex.core.type.ParameterConverter;

public abstract class BaseMethodProxy
implements MethodProxy {
    private final TransactionManager transactionManager;
    private final String sql;
    private final MarkerInfo[] markerInfos;
    private final ParameterConverterRegistry registry;
    private final ExceptionTranslator translator;

    public BaseMethodProxy(Method method, TransactionManager transactionManager, ParameterConverterRegistry registry, ExceptionTranslator translator) {
        this.transactionManager = transactionManager;
        this.translator = translator;
        this.sql = method.getAnnotation(SqlExScript.class).value();
        this.registry = registry;
        int[] markerPositions = method.getAnnotation(SqlExMarkerPosition.class).value();
        int[] parameterPositions = method.getAnnotation(SqlExParameterPosition.class).value();
        SqlExInExprPosition[] inExprPositions = (SqlExInExprPosition[])method.getAnnotationsByType(SqlExInExprPosition.class);
        SqlExIsNullExprPosition[] isNullExprPositions = (SqlExIsNullExprPosition[])method.getAnnotationsByType(SqlExIsNullExprPosition.class);
        this.markerInfos = new MarkerInfo[markerPositions.length];
        for (int index = 0; index < markerPositions.length; ++index) {
            MarkerInfo markerInfo = new MarkerInfo();
            int sqlIndex = markerPositions[index];
            for (SqlExInExprPosition sqlExInExprPosition : inExprPositions) {
                if (sqlExInExprPosition.marker() != sqlIndex) continue;
                markerInfo.inExprPosition = sqlExInExprPosition;
                break;
            }
            for (Annotation annotation : isNullExprPositions) {
                if (annotation.marker() != sqlIndex) continue;
                markerInfo.isNullExprPosition = annotation;
                break;
            }
            markerInfo.argIndex = parameterPositions[index];
            this.markerInfos[index] = markerInfo;
        }
    }

    private void setParameter(PreparedStatement statement, int index, Object arg) throws SQLException {
        if (arg == null) {
            statement.setNull(index, 0);
            return;
        }
        if (arg instanceof Boolean) {
            statement.setBoolean(index, (Boolean)arg);
            return;
        }
        if (arg instanceof Byte) {
            statement.setByte(index, (Byte)arg);
            return;
        }
        if (arg instanceof Short) {
            statement.setShort(index, (Short)arg);
            return;
        }
        if (arg instanceof Integer) {
            statement.setInt(index, (Integer)arg);
            return;
        }
        if (arg instanceof Long) {
            statement.setLong(index, (Long)arg);
            return;
        }
        if (arg instanceof Float) {
            statement.setFloat(index, ((Float)arg).floatValue());
            return;
        }
        if (arg instanceof Double) {
            statement.setDouble(index, (Double)arg);
            return;
        }
        if (arg instanceof Character) {
            statement.setString(index, arg.toString());
            return;
        }
        if (arg instanceof String) {
            statement.setString(index, (String)arg);
            return;
        }
        if (arg instanceof BigDecimal) {
            statement.setBigDecimal(index, (BigDecimal)arg);
            return;
        }
        if (arg instanceof byte[]) {
            statement.setBytes(index, (byte[])arg);
            return;
        }
        if (arg instanceof Blob) {
            statement.setBlob(index, (Blob)arg);
            return;
        }
        if (arg instanceof Date) {
            statement.setDate(index, (Date)arg);
            return;
        }
        if (arg instanceof Time) {
            statement.setTime(index, (Time)arg);
            return;
        }
        if (arg instanceof Timestamp) {
            statement.setTimestamp(index, (Timestamp)arg);
            return;
        }
        if (arg instanceof java.util.Date) {
            statement.setTimestamp(index, new Timestamp(((java.util.Date)arg).getTime()));
            return;
        }
        if (arg instanceof LocalDate || arg instanceof LocalTime || arg instanceof LocalDateTime || arg instanceof OffsetTime || arg instanceof OffsetDateTime || arg instanceof ZonedDateTime) {
            statement.setObject(index, arg);
            return;
        }
        if (arg instanceof Instant) {
            statement.setTimestamp(index, Timestamp.from((Instant)arg));
            return;
        }
        ParameterConverter<Object, Object> converter = this.registry.getConverterFor(arg);
        if (converter != null) {
            Object convertedArg = converter.convert(arg);
            this.setParameter(statement, index, convertedArg);
            return;
        }
        throw new SqlExImpossibleException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u6570\u636e\u7c7b\u578b");
    }

    protected List<Object> reorderArgs(Object[] methodArgs) {
        ArrayList<Object> reorderArgs = new ArrayList<Object>(this.markerInfos.length);
        for (MarkerInfo markerInfo : this.markerInfos) {
            Object methodArg = methodArgs[markerInfo.argIndex];
            if (markerInfo.inExprPosition != null) {
                if (methodArg == null) continue;
                if (methodArg instanceof List) {
                    List listArg = (List)methodArg;
                    if (listArg.size() == 0) continue;
                    reorderArgs.addAll(listArg);
                    continue;
                }
                reorderArgs.add(methodArg);
                continue;
            }
            if (markerInfo.isNullExprPosition != null) continue;
            reorderArgs.add(methodArg);
        }
        return reorderArgs;
    }

    protected String rewriteSQL(Object[] methodArgs) {
        LinkedList<RewriteInfo> rewriteInfos = new LinkedList<RewriteInfo>();
        for (MarkerInfo markerInfo : this.markerInfos) {
            Object methodArg = methodArgs[markerInfo.argIndex];
            if (markerInfo.inExprPosition != null) {
                if (methodArg == null) {
                    rewriteInfos.add(new RewriteInfo(markerInfo.inExprPosition.start(), markerInfo.inExprPosition.end(), markerInfo.inExprPosition.not() ? "1=1" : "1=2"));
                } else if (methodArg instanceof List) {
                    List listArg = (List)methodArg;
                    if (listArg.size() == 0) {
                        rewriteInfos.add(new RewriteInfo(markerInfo.inExprPosition.start(), markerInfo.inExprPosition.end(), markerInfo.inExprPosition.not() ? "1=1" : "1=2"));
                    } else {
                        String markerPart = listArg.stream().map(it -> "?").collect(Collectors.joining(","));
                        rewriteInfos.add(new RewriteInfo(markerInfo.inExprPosition.marker(), markerInfo.inExprPosition.marker() + 1, markerPart));
                    }
                }
            }
            if (markerInfo.isNullExprPosition == null) continue;
            boolean argIsNull = methodArg == null;
            boolean sqlIsNull = !markerInfo.isNullExprPosition.not();
            rewriteInfos.add(new RewriteInfo(markerInfo.isNullExprPosition.start(), markerInfo.isNullExprPosition.end(), argIsNull == sqlIsNull ? "1=1" : "1=2"));
        }
        StringBuilder rewrittenSQL = new StringBuilder(this.sql);
        while (!rewriteInfos.isEmpty()) {
            RewriteInfo rewriteInfo = (RewriteInfo)rewriteInfos.remove(0);
            rewrittenSQL.replace(rewriteInfo.start, rewriteInfo.end, rewriteInfo.content);
            int sizeGrow = rewriteInfo.content.length() - (rewriteInfo.end - rewriteInfo.start);
            rewriteInfos.forEach(info -> {
                if (info.start >= rewriteInfo.end) {
                    info.start += sizeGrow;
                    info.end += sizeGrow;
                }
            });
        }
        return rewrittenSQL.toString();
    }

    protected void setParameters(PreparedStatement statement, List<Object> args) throws SQLException {
        for (int i = 0; i < args.size(); ++i) {
            this.setParameter(statement, i + 1, args.get(i));
        }
    }

    @Override
    public Object invoke(Object[] args) {
        Transaction currentTransaction = this.transactionManager.getCurrentTransaction();
        Connection connection = currentTransaction != null ? currentTransaction.getConnection() : this.transactionManager.newConnection();
        try {
            Object object = this.invoke(args, connection);
            return object;
        }
        catch (SQLException e) {
            throw this.translator.translate(e);
        }
        finally {
            if (currentTransaction == null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw this.translator.translate(e);
                }
            }
        }
    }

    protected abstract Object invoke(Object[] var1, Connection var2) throws SQLException;

    private static class RewriteInfo {
        public int start;
        public int end;
        public String content;

        public RewriteInfo(int start, int end, String content) {
            this.start = start;
            this.end = end;
            this.content = content;
        }
    }

    private static class MarkerInfo {
        public int argIndex;
        public SqlExInExprPosition inExprPosition;
        public SqlExIsNullExprPosition isNullExprPosition;

        private MarkerInfo() {
        }
    }
}

