/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.core.invoke.method;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import me.danwi.sqlex.core.ExceptionTranslator;
import me.danwi.sqlex.core.annotation.SqlExOneColumn;
import me.danwi.sqlex.core.exception.SqlExImpossibleException;
import me.danwi.sqlex.core.invoke.mapper.BasicTypeMapper;
import me.danwi.sqlex.core.invoke.mapper.BeanMapper;
import me.danwi.sqlex.core.invoke.mapper.RowMapper;
import me.danwi.sqlex.core.invoke.method.BaseMethodProxy;
import me.danwi.sqlex.core.repository.ParameterConverterRegistry;
import me.danwi.sqlex.core.transaction.TransactionManager;

public class SelectMethodProxy
extends BaseMethodProxy {
    private final RowMapper rowMapper;

    public SelectMethodProxy(Method method, TransactionManager transactionManager, ParameterConverterRegistry registry, ExceptionTranslator translator) {
        super(method, transactionManager, registry, translator);
        Class<?> entityType = this.getEntityType(method);
        if (entityType == null) {
            throw new SqlExImpossibleException("\u65e0\u6cd5\u786e\u5b9a\u8fd4\u56de\u503c\u7c7b\u578b");
        }
        this.rowMapper = method.getAnnotation(SqlExOneColumn.class) != null ? new BasicTypeMapper(entityType) : new BeanMapper(entityType);
    }

    protected Class<?> getEntityType(Method method) {
        Type[] actualTypeArguments;
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments()) != null && actualTypeArguments.length == 1 && actualTypeArguments[0] instanceof Class) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    protected RowMapper getRowMapper() {
        return this.rowMapper;
    }

    @Override
    protected Object invoke(Object[] args, Connection connection) throws SQLException {
        String sql = this.rewriteSQL(args);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            List<?> list;
            block12: {
                List<Object> reorderArgs = this.reorderArgs(args);
                this.setParameters(statement, reorderArgs);
                ResultSet rs = statement.executeQuery();
                try {
                    list = this.getRowMapper().fetch(rs);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }
}

