/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.danwi.sqlex.common.SQLUtils;
import me.danwi.sqlex.parser.PlanInfo;
import me.danwi.sqlex.parser.Session;
import me.danwi.sqlex.parser.StatementInfo;
import me.danwi.sqlex.parser.TableInfo;
import me.danwi.sqlex.parser.config.SqlExConfig;
import me.danwi.sqlex.parser.generate.GeneratedEntityFile;
import me.danwi.sqlex.parser.generate.GeneratedMethodFile;
import me.danwi.sqlex.parser.generate.GeneratedRepositoryFile;
import me.danwi.sqlex.parser.generate.GeneratedTableFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00150\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\bJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\bJ\u000e\u0010)\u001a\u00020*2\u0006\u0010(\u001a\u00020\bJ\u0019\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0,2\u0006\u0010-\u001a\u00020\b\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 \u00a8\u0006/"}, d2={"Lme/danwi/sqlex/parser/Repository;", "", "session", "Lme/danwi/sqlex/parser/Session;", "config", "Lme/danwi/sqlex/parser/config/SqlExConfig;", "schemas", "", "", "foreignDatabaseNameMapping", "", "foreignSchemas", "<init>", "(Lme/danwi/sqlex/parser/Session;Lme/danwi/sqlex/parser/config/SqlExConfig;Ljava/util/List;Ljava/util/Map;Ljava/util/Map;)V", "rootPackage", "converters", "generateRepositoryClassFile", "Lme/danwi/sqlex/parser/generate/GeneratedRepositoryFile;", "tableClassNames", "methodClassNames", "generateEntityAndTableClassFiles", "Lkotlin/Pair;", "Lme/danwi/sqlex/parser/generate/GeneratedEntityFile;", "Lme/danwi/sqlex/parser/generate/GeneratedTableFile;", "generateMethodClassFile", "Lme/danwi/sqlex/parser/generate/GeneratedMethodFile;", "relativePath", "content", "close", "", "selfDDL", "getSelfDDL", "()Ljava/lang/String;", "DDL", "getDDL", "getTableInfo", "Lme/danwi/sqlex/parser/TableInfo;", "tableName", "getStatementInfo", "Lme/danwi/sqlex/parser/StatementInfo;", "sql", "getPlanInfo", "Lme/danwi/sqlex/parser/PlanInfo;", "getSQLsOfScript", "", "script", "(Ljava/lang/String;)[Ljava/lang/String;", "parser"})
@SourceDebugExtension(value={"SMAP\nRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Repository.kt\nme/danwi/sqlex/parser/Repository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,330:1\n11228#2:331\n11563#2,3:332\n1869#3,2:335\n216#4,2:337\n*S KotlinDebug\n*F\n+ 1 Repository.kt\nme/danwi/sqlex/parser/Repository\n*L\n142#1:331\n142#1:332,3\n156#1:335,2\n176#1:337,2\n*E\n"})
public final class Repository {
    @NotNull
    private final Session session;
    @NotNull
    private final SqlExConfig config;
    @NotNull
    private final List<String> schemas;
    @NotNull
    private final Map<String, String> foreignDatabaseNameMapping;
    @NotNull
    private final Map<String, String> foreignSchemas;
    @NotNull
    private final String rootPackage;
    @NotNull
    private final List<String> converters;
    @NotNull
    private final String selfDDL;

    public Repository(@NotNull Session session, @NotNull SqlExConfig config, @NotNull List<String> schemas, @NotNull Map<String, String> foreignDatabaseNameMapping, @NotNull Map<String, String> foreignSchemas) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        Intrinsics.checkNotNullParameter(foreignDatabaseNameMapping, (String)"foreignDatabaseNameMapping");
        Intrinsics.checkNotNullParameter(foreignSchemas, (String)"foreignSchemas");
        this.session = session;
        this.config = config;
        this.schemas = schemas;
        this.foreignDatabaseNameMapping = foreignDatabaseNameMapping;
        this.foreignSchemas = foreignSchemas;
        this.rootPackage = this.config.getRootPackage();
        this.converters = this.config.getConverters();
        this.selfDDL = this.session.getDDL();
    }

    @NotNull
    public final GeneratedRepositoryFile generateRepositoryClassFile(@NotNull List<String> tableClassNames, @NotNull List<String> methodClassNames) {
        Intrinsics.checkNotNullParameter(tableClassNames, (String)"tableClassNames");
        Intrinsics.checkNotNullParameter(methodClassNames, (String)"methodClassNames");
        return new GeneratedRepositoryFile(this.rootPackage, this.converters, this.schemas, tableClassNames, methodClassNames, this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<GeneratedEntityFile, GeneratedTableFile>> generateEntityAndTableClassFiles() {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = this.session.getAllTables();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GeneratedEntityFile entityFile = new GeneratedEntityFile(this.rootPackage, (String)it, this);
            GeneratedTableFile tableFile = new GeneratedTableFile(this.rootPackage, (String)it, entityFile.getQualifiedName(), this);
            collection.add(new Pair((Object)entityFile, (Object)tableFile));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final GeneratedMethodFile generateMethodClassFile(@NotNull String relativePath, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return new GeneratedMethodFile(this.rootPackage, relativePath, content, this);
    }

    public final void close() {
        Iterable $this$forEach$iv = this.foreignDatabaseNameMapping.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                this.session.execute("drop database " + it);
            }
            catch (Exception exception) {
            }
        }
        this.session.dropDatabaseAndClose();
    }

    @NotNull
    public final String getSelfDDL() {
        return this.selfDDL;
    }

    @NotNull
    public final String getDDL() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.selfDDL);
        builder.append('\n');
        Map<String, String> $this$forEach$iv = this.foreignDatabaseNameMapping;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String ddl;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String databaseName = entry.getKey();
            if (this.foreignSchemas.get(databaseName) == null) continue;
            builder.append("\n# schema of " + databaseName + "\n\n");
            builder.append("create database " + databaseName + ";\n\n");
            builder.append("use " + databaseName + ";\n\n");
            builder.append(ddl);
            builder.append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final TableInfo getTableInfo(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return this.session.getTableInfo(tableName);
    }

    @NotNull
    public final StatementInfo getStatementInfo(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return this.session.getStatementInfo(sql);
    }

    @NotNull
    public final PlanInfo getPlanInfo(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        String string = SQLUtils.replaceDatabaseName((String)sql, this.foreignDatabaseNameMapping);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replaceDatabaseName(...)");
        return this.session.getPlanInfo(string);
    }

    @NotNull
    public final String[] getSQLsOfScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.session.getSQLsOfScript(script);
    }
}

