/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.danwi.sqlex.parser.Repository;
import me.danwi.sqlex.parser.RepositoryKt;
import me.danwi.sqlex.parser.Session;
import me.danwi.sqlex.parser.config.SqlExConfig;
import me.danwi.sqlex.parser.exception.SqlExRepositorySchemaException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lme/danwi/sqlex/parser/RepositoryBuilder;", "", "config", "Lme/danwi/sqlex/parser/config/SqlExConfig;", "<init>", "(Lme/danwi/sqlex/parser/config/SqlExConfig;)V", "databaseName", "", "foreignDatabaseNameMapping", "", "foreignSchemas", "session", "Lme/danwi/sqlex/parser/Session;", "rootPackageRelativePath", "currentSchemaVersion", "", "schemaContentCache", "", "addForeignSchema", "", "ddl", "addSchema", "relativePath", "script", "build", "Lme/danwi/sqlex/parser/Repository;", "close", "parser"})
@SourceDebugExtension(value={"SMAP\nRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Repository.kt\nme/danwi/sqlex/parser/RepositoryBuilder\n+ 2 StringExtension.kt\nme/danwi/sqlex/parser/util/StringExtensionKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,330:1\n69#2:331\n40#2,4:332\n54#2:336\n40#2,4:337\n56#2,9:341\n40#2,4:350\n56#2,9:354\n83#2:363\n40#2,4:364\n1869#3,2:368\n*S KotlinDebug\n*F\n+ 1 Repository.kt\nme/danwi/sqlex/parser/RepositoryBuilder\n*L\n31#1:331\n31#1:332,4\n58#1:336\n58#1:337,4\n58#1:341,9\n58#1:350,4\n58#1:354,9\n62#1:363\n62#1:364,4\n105#1:368,2\n*E\n"})
public final class RepositoryBuilder {
    @NotNull
    private final SqlExConfig config;
    @NotNull
    private final String databaseName;
    @NotNull
    private final Map<String, String> foreignDatabaseNameMapping;
    @NotNull
    private final Map<String, String> foreignSchemas;
    @NotNull
    private final Session session;
    @NotNull
    private final String rootPackageRelativePath;
    private int currentSchemaVersion;
    @NotNull
    private final List<String> schemaContentCache;

    public RepositoryBuilder(@NotNull SqlExConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.databaseName = "sqlex_" + RepositoryKt.access$getIndex$p().getAndIncrement();
        this.foreignDatabaseNameMapping = new LinkedHashMap();
        this.foreignSchemas = new LinkedHashMap();
        this.session = new Session(this.databaseName);
        String $this$packageNameToRelativePath$iv = this.config.getRootPackage();
        boolean $i$f$getPackageNameToRelativePath = false;
        String $this$windowsPathNormalize$iv$iv = $this$packageNameToRelativePath$iv;
        boolean $i$f$getWindowsPathNormalize = false;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.rootPackageRelativePath = StringsKt.replace$default((String)(StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv), (char)'.', (char)'/', (boolean)false, (int)4, null);
        this.currentSchemaVersion = -1;
        this.schemaContentCache = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addForeignSchema(@NotNull String databaseName, @NotNull String ddl) {
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)ddl, (String)"ddl");
        String mappingDatabaseName = "sqlex_" + RepositoryKt.access$getIndex$p().getAndIncrement();
        try (Session foreignSession = new Session(mappingDatabaseName);){
            foreignSession.executeScript(ddl);
            this.foreignDatabaseNameMapping.put(databaseName, mappingDatabaseName);
            this.foreignSchemas.put(databaseName, ddl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSchema(@NotNull String relativePath, @NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        try {
            Integer version;
            if (!StringsKt.startsWith$default((String)relativePath, (String)this.rootPackageRelativePath, (boolean)false, (int)2, null)) {
                String normalizedPath$iv;
                StringBuilder stringBuilder = new StringBuilder().append("Schema\u6587\u4ef6\u5fc5\u987b\u5728\u6839\u5305\u4e0b,\u5f53\u524d\u6839\u5305: ");
                String $this$relativePathToPackageName$iv = this.rootPackageRelativePath;
                boolean $i$f$getRelativePathToPackageName = false;
                String $this$windowsPathNormalize$iv$iv = $this$relativePathToPackageName$iv;
                boolean $i$f$getWindowsPathNormalize = false;
                String string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                String string2 = normalizedPath$iv = StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv;
                StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.contains$default((CharSequence)StringsKt.substringAfterLast$default((String)normalizedPath$iv, (String)"/", null, (int)2, null), (CharSequence)".", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.substringBeforeLast$default((String)normalizedPath$iv, (char)'/', null, (int)2, null), (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null) : StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)normalizedPath$iv, (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null)).append(" ,Schema\u6587\u4ef6\u6240\u5728\u5305: ");
                $this$relativePathToPackageName$iv = relativePath;
                $i$f$getRelativePathToPackageName = false;
                $this$windowsPathNormalize$iv$iv = $this$relativePathToPackageName$iv;
                $i$f$getWindowsPathNormalize = false;
                String string3 = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
                String string4 = normalizedPath$iv = StringsKt.startsWith$default((String)string3, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv;
                throw new SqlExRepositorySchemaException(relativePath, stringBuilder2.append(StringsKt.contains$default((CharSequence)StringsKt.substringAfterLast$default((String)normalizedPath$iv, (String)"/", null, (int)2, null), (CharSequence)".", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.substringBeforeLast$default((String)normalizedPath$iv, (char)'/', null, (int)2, null), (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null) : StringsKt.replace$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)normalizedPath$iv, (CharSequence)"/"), (CharSequence)"/"), (char)'/', (char)'.', (boolean)false, (int)4, null)).toString());
            }
            String $this$schemaFileVersion$iv22 = relativePath;
            boolean $i$f$getSchemaFileVersion = false;
            Regex regex = new Regex("^(\\d+)");
            String $this$windowsPathNormalize$iv$iv = $this$schemaFileVersion$iv22;
            boolean $i$f$getWindowsPathNormalize = false;
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
            Object object = Regex.find$default((Regex)regex, (CharSequence)StringsKt.substringAfterLast$default((String)(StringsKt.startsWith$default((String)string, (String)"Windows", (boolean)false, (int)2, null) ? StringsKt.replace$default((String)$this$windowsPathNormalize$iv$iv, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null) : $this$windowsPathNormalize$iv$iv), (String)"/", null, (int)2, null), (int)0, (int)2, null);
            Integer n = version = object != null && (object = object.getGroups()) != null && (object = object.get(0)) != null && (object = object.getValue()) != null ? Integer.valueOf(Integer.parseInt((String)object)) : null;
            int $this$schemaFileVersion$iv22 = this.currentSchemaVersion + 1;
            if (n == null || n != $this$schemaFileVersion$iv22) {
                if (this.currentSchemaVersion == -1) {
                    throw new SqlExRepositorySchemaException(relativePath, "Schema\u6587\u4ef6\u7684\u7248\u672c\u5fc5\u987b\u4ece0\u5f00\u59cb");
                }
                throw new SqlExRepositorySchemaException(relativePath, "Schema\u6587\u4ef6\u7248\u672c\u5fc5\u987b\u8fde\u7eed\u4e14\u4e0d\u91cd\u590d,\u5f53\u524d\u9700\u8981 " + (this.currentSchemaVersion + 1) + " \u7248\u672c,\u5b9e\u9645\u63d0\u4f9b " + version + " \u7248\u672c");
            }
            this.session.executeScript(script);
            this.schemaContentCache.add(script);
            $this$schemaFileVersion$iv22 = this.currentSchemaVersion;
            this.currentSchemaVersion = $this$schemaFileVersion$iv22 + 1;
        }
        catch (Exception e) {
            try {
                this.session.execute("drop database " + this.databaseName);
            }
            finally {
                this.session.close();
                throw new SqlExRepositorySchemaException(relativePath, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Repository build() {
        try {
            Repository repository = new Repository(new Session(this.databaseName), this.config, this.schemaContentCache, this.foreignDatabaseNameMapping, this.foreignSchemas);
            return repository;
        }
        catch (Exception e) {
            this.session.dropDatabaseAndClose();
            throw e;
        }
        finally {
            this.session.close();
        }
    }

    public final void close() {
        Iterable $this$forEach$iv = this.foreignDatabaseNameMapping.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                this.session.execute("drop database " + it);
            }
            catch (Exception exception) {
            }
        }
        this.session.dropDatabaseAndClose();
    }
}

