/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser.generate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.danwi.sqlex.core.annotation.SqlExRepository;
import me.danwi.sqlex.core.annotation.SqlExTableAccessObject;
import me.danwi.sqlex.core.jdbc.RawSQLExecutor;
import me.danwi.sqlex.core.query.Column;
import me.danwi.sqlex.core.query.InsertOption;
import me.danwi.sqlex.core.query.TableDelete;
import me.danwi.sqlex.core.query.TableInsert;
import me.danwi.sqlex.core.query.TableQuery;
import me.danwi.sqlex.core.query.TableUpdate;
import me.danwi.sqlex.core.query.expression.Expression;
import me.danwi.sqlex.parser.Field;
import me.danwi.sqlex.parser.Repository;
import me.danwi.sqlex.parser.TableInfo;
import me.danwi.sqlex.parser.generate.GeneratedJavaFile;
import me.danwi.sqlex.parser.util.StringExtensionKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002J\u001b\u0010\u001c\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lme/danwi/sqlex/parser/generate/GeneratedTableFile;", "Lme/danwi/sqlex/parser/generate/GeneratedJavaFile;", "rootPackage", "", "tableName", "entityQualifiedName", "repository", "Lme/danwi/sqlex/parser/Repository;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lme/danwi/sqlex/parser/Repository;)V", "entityTypeName", "Lcom/squareup/javapoet/ClassName;", "updateClassName", "updateClassTypeName", "kotlin.jvm.PlatformType", "generate", "Lcom/squareup/javapoet/TypeSpec;", "generateColumnExpression", "", "Lcom/squareup/javapoet/FieldSpec;", "columns", "", "Lme/danwi/sqlex/parser/Field;", "([Lme/danwi/sqlex/parser/Field;)Ljava/util/List;", "generateFields", "generateConstructorMethod", "Lcom/squareup/javapoet/MethodSpec;", "generatedColumn", "generateUpdateClass", "([Lme/danwi/sqlex/parser/Field;)Lcom/squareup/javapoet/TypeSpec;", "generateUpdateMethod", "generateDeleteMethod", "generateSelectMethod", "generateShortCutMethods", "tableInfo", "Lme/danwi/sqlex/parser/TableInfo;", "parser"})
@SourceDebugExtension(value={"SMAP\nGeneratedTableFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratedTableFile.kt\nme/danwi/sqlex/parser/generate/GeneratedTableFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 extensions.kt\nme/danwi/sqlex/parser/generate/ExtensionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n1#2:300\n1#2:629\n1#2:715\n24#3,65:301\n96#3,38:369\n24#3,65:408\n24#3,65:476\n24#3,65:559\n24#3,65:645\n24#3,65:718\n11228#4:366\n11563#4,2:367\n11565#4:407\n11228#4:473\n11563#4,2:474\n11565#4:541\n11228#4:542\n11563#4,3:543\n1617#5,9:546\n1869#5:555\n1563#5:556\n1634#5,2:557\n1636#5:624\n1563#5:625\n1634#5,3:626\n1870#5:630\n1626#5:631\n1617#5,9:632\n1869#5:641\n1563#5:642\n1634#5,2:643\n1636#5:710\n1563#5:711\n1634#5,3:712\n1870#5:716\n1626#5:717\n1869#5:783\n1563#5:784\n1634#5,3:785\n1870#5:788\n*S KotlinDebug\n*F\n+ 1 GeneratedTableFile.kt\nme/danwi/sqlex/parser/generate/GeneratedTableFile\n*L\n204#1:629\n225#1:715\n36#1:301,65\n86#1:369,38\n115#1:408,65\n145#1:476,65\n205#1:559,65\n226#1:645,65\n257#1:718,65\n78#1:366\n78#1:367,2\n78#1:407\n144#1:473\n144#1:474,2\n144#1:541\n201#1:542\n201#1:543,3\n204#1:546,9\n204#1:555\n205#1:556\n205#1:557,2\n205#1:624\n206#1:625\n206#1:626,3\n204#1:630\n204#1:631\n225#1:632,9\n225#1:641\n226#1:642\n226#1:643,2\n226#1:710\n227#1:711\n227#1:712,3\n225#1:716\n225#1:717\n266#1:783\n267#1:784\n267#1:785,3\n266#1:788\n*E\n"})
public final class GeneratedTableFile
extends GeneratedJavaFile {
    @NotNull
    private final String rootPackage;
    @NotNull
    private final String tableName;
    @NotNull
    private final Repository repository;
    @NotNull
    private final ClassName entityTypeName;
    @NotNull
    private final String updateClassName;
    private final ClassName updateClassTypeName;

    public GeneratedTableFile(@NotNull String rootPackage, @NotNull String tableName, @NotNull String entityQualifiedName, @NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)rootPackage, (String)"rootPackage");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)entityQualifiedName, (String)"entityQualifiedName");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        super(rootPackage, StringExtensionKt.getPascalName(tableName) + "Table");
        this.rootPackage = rootPackage;
        this.tableName = tableName;
        this.repository = repository;
        ClassName className = ClassName.bestGuess((String)("sqlex.no.not.hide.package." + entityQualifiedName));
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"bestGuess(...)");
        this.entityTypeName = className;
        this.updateClassName = "Update";
        String[] stringArray = new String[]{this.updateClassName};
        this.updateClassTypeName = ClassName.get((String)this.rootPackage, (String)this.getClassName(), (String[])stringArray);
    }

    @Override
    @NotNull
    protected TypeSpec generate() {
        TypeName generatedColumn;
        TypeName typeName;
        TableInfo tableInfo;
        block50: {
            block49: {
                TypeName typeName2;
                Object object;
                Object[] objectArray;
                block48: {
                    tableInfo = this.repository.getTableInfo(this.tableName);
                    Field[] fieldArray = tableInfo.getColumns();
                    int n = fieldArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object[] it = objectArray = fieldArray[i];
                        boolean bl = false;
                        if (!it.isAutoIncrement()) continue;
                        object = objectArray;
                        break block48;
                    }
                    object = null;
                }
                if ((typeName = (generatedColumn = object)) == null) break block49;
                TypeName $this$JavaType$iv = typeName;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                    if ($this$JavaType$iv.getLength() == 1L) {
                        TypeName typeName3 = ClassName.BOOLEAN.box();
                        typeName2 = typeName3;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"box(...)");
                    } else {
                        ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                        typeName2 = (TypeName)arrayTypeName;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv;
                    if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                        TypeName typeName4 = ClassName.BOOLEAN.box();
                        typeName2 = typeName4;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName4, (String)"box(...)");
                    } else {
                        TypeName typeName5 = ClassName.INT.box();
                        typeName2 = typeName5;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName5, (String)"box(...)");
                    }
                } else {
                    objectArray = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])objectArray).contains($this$JavaType$iv.getDbType())) {
                        TypeName typeName6 = ClassName.INT.box();
                        typeName2 = typeName6;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName6, (String)"box(...)");
                    } else {
                        objectArray = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])objectArray).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                TypeName typeName7 = ClassName.LONG.box();
                                typeName2 = typeName7;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName7, (String)"box(...)");
                            } else {
                                TypeName typeName8 = ClassName.INT.box();
                                typeName2 = typeName8;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName8, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                ClassName className = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                typeName2 = (TypeName)className;
                            } else {
                                TypeName typeName9 = ClassName.LONG.box();
                                typeName2 = typeName9;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName9, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                            TypeName typeName10 = ClassName.FLOAT.box();
                            typeName2 = typeName10;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName10, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                            TypeName typeName11 = ClassName.DOUBLE.box();
                            typeName2 = typeName11;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName11, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                            ClassName className = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName2 = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName2 = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                            ClassName className = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName2 = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                            ClassName className = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName2 = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                            ClassName className = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName2 = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName2 = (TypeName)className;
                        } else {
                            objectArray = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])objectArray).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getBinary()) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName2 = (TypeName)arrayTypeName;
                                } else {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName2 = (TypeName)className;
                                }
                            } else {
                                objectArray = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])objectArray).contains($this$JavaType$iv.getDbType())) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName2 = (TypeName)arrayTypeName;
                                } else {
                                    objectArray = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])objectArray).contains($this$JavaType$iv.getDbType())) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName2 = (TypeName)className;
                                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName2 = (TypeName)className;
                                    } else {
                                        throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                typeName = typeName2;
                if (typeName2 != null) break block50;
            }
            typeName = (TypeName)ClassName.get(Void.class);
        }
        TypeName generatedColumnJavaType = typeName;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.getClassName()).addModifiers(objectArray);
        objectArray = new TypeName[]{this.entityTypeName, generatedColumnJavaType};
        TypeSpec.Builder builder2 = builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TableInsert.class), (TypeName[])objectArray));
        objectArray = new Object[]{ClassName.get((String)this.rootPackage, (String)"Repository", (String[])new String[0])};
        TypeSpec.Builder typeSpecBuilder = builder2.addAnnotation(AnnotationSpec.builder(SqlExRepository.class).addMember("value", "$T.class", objectArray).build()).addAnnotation(SqlExTableAccessObject.class);
        typeSpecBuilder.addFields((Iterable)this.generateFields());
        typeSpecBuilder.addMethod(this.generateConstructorMethod((Field)generatedColumn));
        typeSpecBuilder.addFields((Iterable)this.generateColumnExpression(tableInfo.getColumns()));
        typeSpecBuilder.addType(this.generateUpdateClass(tableInfo.getColumns()));
        typeSpecBuilder.addMethod(this.generateUpdateMethod());
        typeSpecBuilder.addMethod(this.generateDeleteMethod());
        typeSpecBuilder.addMethod(this.generateSelectMethod());
        typeSpecBuilder.addMethods((Iterable)this.generateShortCutMethods(tableInfo));
        TypeSpec typeSpec = typeSpecBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"build(...)");
        return typeSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FieldSpec> generateColumnExpression(Field[] columns) {
        void $this$mapTo$iv$iv;
        Field[] $this$map$iv = columns;
        boolean $i$f$map = false;
        Field[] fieldArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            JDBCType jDBCType;
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL};
            FieldSpec.Builder builder = FieldSpec.builder((TypeName)((TypeName)ClassName.get(Column.class)), (String)StringExtensionKt.getPascalName(it.getName()), (Modifier[])new Modifier[0]).addModifiers(objectArray);
            objectArray = new Object[14];
            objectArray[0] = ClassName.get(Column.class);
            objectArray[1] = this.tableName;
            objectArray[2] = it.getName();
            objectArray[3] = it.getDbType();
            StringBuilder stringBuilder = new StringBuilder().append("java.sql.JDBCType.");
            void $this$JdbcType$iv = it;
            boolean $i$f$getJdbcType = false;
            switch ($this$JdbcType$iv.getDbType()) {
                case "bit": {
                    jDBCType = JDBCType.BIT;
                    break;
                }
                case "tinyint": {
                    jDBCType = JDBCType.TINYINT;
                    break;
                }
                case "smallint": {
                    jDBCType = JDBCType.SMALLINT;
                    break;
                }
                case "mediumint": {
                    jDBCType = JDBCType.INTEGER;
                    break;
                }
                case "int": {
                    jDBCType = JDBCType.INTEGER;
                    break;
                }
                case "bigint": {
                    jDBCType = JDBCType.BIGINT;
                    break;
                }
                case "float": {
                    jDBCType = JDBCType.REAL;
                    break;
                }
                case "double": {
                    jDBCType = JDBCType.DOUBLE;
                    break;
                }
                case "decimal": {
                    jDBCType = JDBCType.DECIMAL;
                    break;
                }
                case "date": {
                    jDBCType = JDBCType.DATE;
                    break;
                }
                case "datetime": {
                    jDBCType = JDBCType.TIMESTAMP;
                    break;
                }
                case "timestamp": {
                    jDBCType = JDBCType.TIMESTAMP;
                    break;
                }
                case "time": {
                    jDBCType = JDBCType.TIME;
                    break;
                }
                case "year": {
                    jDBCType = JDBCType.DATE;
                    break;
                }
                case "char": {
                    if ($this$JdbcType$iv.getBinary()) {
                        jDBCType = JDBCType.BINARY;
                        break;
                    }
                    jDBCType = JDBCType.CHAR;
                    break;
                }
                case "varchar": {
                    if ($this$JdbcType$iv.getBinary()) {
                        jDBCType = JDBCType.VARBINARY;
                        break;
                    }
                    jDBCType = JDBCType.VARCHAR;
                    break;
                }
                case "binary": {
                    jDBCType = JDBCType.BINARY;
                    break;
                }
                case "varbinary": {
                    jDBCType = JDBCType.VARBINARY;
                    break;
                }
                case "tinyblob": {
                    jDBCType = JDBCType.VARBINARY;
                    break;
                }
                case "tinytext": {
                    jDBCType = JDBCType.VARCHAR;
                    break;
                }
                case "blob": {
                    jDBCType = JDBCType.LONGVARBINARY;
                    break;
                }
                case "text": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "mediumblob": {
                    jDBCType = JDBCType.LONGVARBINARY;
                    break;
                }
                case "mediumtext": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "longblob": {
                    jDBCType = JDBCType.LONGVARBINARY;
                    break;
                }
                case "longtext": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "json": {
                    jDBCType = JDBCType.LONGVARCHAR;
                    break;
                }
                case "geometry": {
                    jDBCType = JDBCType.BINARY;
                    break;
                }
                case "enum": {
                    jDBCType = JDBCType.CHAR;
                    break;
                }
                case "set": {
                    jDBCType = JDBCType.CHAR;
                    break;
                }
                case "null": {
                    jDBCType = JDBCType.NULL;
                    break;
                }
                default: {
                    throw new Exception("db[" + $this$JdbcType$iv.getDbType() + "] -> jdbc \u6620\u5c04\u5931\u8d25!!!");
                }
            }
            objectArray[4] = stringBuilder.append(jDBCType.name()).toString();
            objectArray[5] = Long.valueOf(it.getLength());
            objectArray[6] = Boolean.valueOf(it.getUnsigned());
            objectArray[7] = Boolean.valueOf(it.getBinary());
            objectArray[8] = Long.valueOf(it.getDecimal());
            objectArray[9] = Boolean.valueOf(it.isPrimaryKey());
            objectArray[10] = Boolean.valueOf(it.isAutoIncrement());
            objectArray[11] = Boolean.valueOf(it.isUnique());
            objectArray[12] = Boolean.valueOf(it.getNotNull());
            objectArray[13] = Boolean.valueOf(it.getHasDefaultValue());
            collection.add(builder.initializer(CodeBlock.of((String)"new $T($S,$S, $S,$L,$LL, $L,$L,$LL, $L,$L,$L, $L,$L)", (Object[])objectArray)).build());
        }
        return (List)destination$iv$iv;
    }

    private final List<FieldSpec> generateFields() {
        Modifier[] modifierArray = new Modifier[]{Modifier.PRIVATE, Modifier.FINAL};
        return CollectionsKt.listOf((Object)FieldSpec.builder((Type)((Type)((Object)RawSQLExecutor.class)), (String)"executor", (Modifier[])modifierArray).build());
    }

    private final MethodSpec generateConstructorMethod(Field generatedColumn) {
        MethodSpec.Builder builder;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder constructorMethod = MethodSpec.constructorBuilder().addModifiers(objectArray).addParameter((Type)((Object)RawSQLExecutor.class), "executor", new Modifier[0]);
        if (generatedColumn != null) {
            TypeName typeName;
            objectArray = new Object[2];
            objectArray[0] = this.tableName;
            Field $this$JavaType$iv = generatedColumn;
            boolean $i$f$getJavaType = false;
            if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                if ($this$JavaType$iv.getLength() == 1L) {
                    TypeName typeName2 = ClassName.BOOLEAN.box();
                    typeName = typeName2;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName2, (String)"box(...)");
                } else {
                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                    typeName = (TypeName)arrayTypeName;
                }
            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                char thirdChar$iv;
                if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                    TypeName typeName3 = ClassName.BOOLEAN.box();
                    typeName = typeName3;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"box(...)");
                } else {
                    TypeName typeName4 = ClassName.INT.box();
                    typeName = typeName4;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName4, (String)"box(...)");
                }
            } else {
                Object[] objectArray2 = new String[]{"smallint", "mediumint"};
                if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                    TypeName typeName5 = ClassName.INT.box();
                    typeName = typeName5;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName5, (String)"box(...)");
                } else {
                    objectArray2 = new String[]{"int", "integer"};
                    if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            TypeName typeName6 = ClassName.LONG.box();
                            typeName = typeName6;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName6, (String)"box(...)");
                        } else {
                            TypeName typeName7 = ClassName.INT.box();
                            typeName = typeName7;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName7, (String)"box(...)");
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            ClassName className = ClassName.get(BigInteger.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else {
                            TypeName typeName8 = ClassName.LONG.box();
                            typeName = typeName8;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName8, (String)"box(...)");
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                        TypeName typeName9 = ClassName.FLOAT.box();
                        typeName = typeName9;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName9, (String)"box(...)");
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                        TypeName typeName10 = ClassName.DOUBLE.box();
                        typeName = typeName10;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName10, (String)"box(...)");
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                        ClassName className = ClassName.get(BigDecimal.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                        ClassName className = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                        ClassName className = ClassName.get(LocalDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                        ClassName className = ClassName.get(OffsetDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                        ClassName className = ClassName.get(LocalTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                        ClassName className = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else {
                        objectArray2 = new String[]{"char", "varchar"};
                        if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getBinary()) {
                                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                typeName = (TypeName)arrayTypeName;
                            } else {
                                ClassName className = ClassName.get(String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                typeName = (TypeName)className;
                            }
                        } else {
                            objectArray2 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                            if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                typeName = (TypeName)arrayTypeName;
                            } else {
                                objectArray2 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName = (TypeName)className;
                                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName = (TypeName)className;
                                } else {
                                    throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                }
                            }
                        }
                    }
                }
            }
            objectArray[1] = typeName;
            builder = constructorMethod.addCode("super($S, executor, $T.class);\n", objectArray);
        } else {
            objectArray = new Object[]{this.tableName};
            builder = constructorMethod.addCode("super($S, executor, null);\n", objectArray);
        }
        MethodSpec methodSpec = constructorMethod.addCode("this.executor = executor;", new Object[0]).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"build(...)");
        return methodSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSpec generateUpdateClass(Field[] columns) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC, Modifier.STATIC};
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.updateClassName).addModifiers(objectArray);
        objectArray = new TypeName[]{this.updateClassTypeName};
        TypeSpec.Builder typeSpecBuilder = builder.superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TableUpdate.class), (TypeName[])objectArray));
        objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder2 = MethodSpec.constructorBuilder().addModifiers(objectArray).addParameter((Type)((Object)RawSQLExecutor.class), "executor", new Modifier[0]);
        objectArray = new Object[]{this.tableName};
        typeSpecBuilder.addMethod(builder2.addCode("super($S, executor);\n", objectArray).build());
        objectArray = columns;
        TypeSpec.Builder builder3 = typeSpecBuilder;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            TypeName typeName;
            void it;
            void item$iv$iv;
            void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$JavaType$iv = it;
            boolean $i$f$getJavaType = false;
            if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                if ($this$JavaType$iv.getLength() == 1L) {
                    TypeName typeName2 = ClassName.BOOLEAN.box();
                    typeName = typeName2;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName2, (String)"box(...)");
                } else {
                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                    typeName = (TypeName)arrayTypeName;
                }
            } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                char thirdChar$iv;
                if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                    TypeName typeName3 = ClassName.BOOLEAN.box();
                    typeName = typeName3;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"box(...)");
                } else {
                    TypeName typeName4 = ClassName.INT.box();
                    typeName = typeName4;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName4, (String)"box(...)");
                }
            } else {
                Object[] objectArray2 = new String[]{"smallint", "mediumint"};
                if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                    TypeName typeName5 = ClassName.INT.box();
                    typeName = typeName5;
                    Intrinsics.checkNotNullExpressionValue((Object)typeName5, (String)"box(...)");
                } else {
                    objectArray2 = new String[]{"int", "integer"};
                    if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            TypeName typeName6 = ClassName.LONG.box();
                            typeName = typeName6;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName6, (String)"box(...)");
                        } else {
                            TypeName typeName7 = ClassName.INT.box();
                            typeName = typeName7;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName7, (String)"box(...)");
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                        if ($this$JavaType$iv.getUnsigned()) {
                            ClassName className = ClassName.get(BigInteger.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else {
                            TypeName typeName8 = ClassName.LONG.box();
                            typeName = typeName8;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName8, (String)"box(...)");
                        }
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                        TypeName typeName9 = ClassName.FLOAT.box();
                        typeName = typeName9;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName9, (String)"box(...)");
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                        TypeName typeName10 = ClassName.DOUBLE.box();
                        typeName = typeName10;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName10, (String)"box(...)");
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                        ClassName className = ClassName.get(BigDecimal.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                        ClassName className = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                        ClassName className = ClassName.get(LocalDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                        ClassName className = ClassName.get(OffsetDateTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                        ClassName className = ClassName.get(LocalTime.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                        ClassName className = ClassName.get(LocalDate.class);
                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                        typeName = (TypeName)className;
                    } else {
                        objectArray2 = new String[]{"char", "varchar"};
                        if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getBinary()) {
                                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                typeName = (TypeName)arrayTypeName;
                            } else {
                                ClassName className = ClassName.get(String.class);
                                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                typeName = (TypeName)className;
                            }
                        } else {
                            objectArray2 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                            if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                typeName = (TypeName)arrayTypeName;
                            } else {
                                objectArray2 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName = (TypeName)className;
                                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName = (TypeName)className;
                                } else {
                                    throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                }
                            }
                        }
                    }
                }
            }
            ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)typeName, (String)"value", (Modifier[])new Modifier[0]).addAnnotation(it.getNotNull() ? NotNull.class : Nullable.class);
            Object[] objectArray3 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec.Builder builder4 = MethodSpec.methodBuilder((String)("set" + StringExtensionKt.getPascalName(it.getName()))).addModifiers(objectArray3).returns((TypeName)this.updateClassTypeName).addParameter(parameterSpec.build());
            objectArray3 = new Object[]{it.getName()};
            collection.add(builder4.addCode("super.values.put($S, value);\n", objectArray3).addCode("return this;", new Object[0]).build());
        }
        builder3.addMethods((Iterable)((List)destination$iv$iv));
        TypeSpec typeSpec = typeSpecBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"build(...)");
        return typeSpec;
    }

    private final MethodSpec generateUpdateMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"update").addModifiers(objectArray).returns((TypeName)this.updateClassTypeName);
        objectArray = new Object[]{this.updateClassTypeName};
        MethodSpec methodSpec = builder.addCode("return new $T(this.executor);", objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"build(...)");
        return methodSpec;
    }

    private final MethodSpec generateDeleteMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"delete").addModifiers(objectArray).returns((TypeName)ClassName.get(TableDelete.class));
        objectArray = new Object[]{TableDelete.class, this.tableName};
        MethodSpec methodSpec = builder.addCode("return new $T($S, this.executor);", objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"build(...)");
        return methodSpec;
    }

    private final MethodSpec generateSelectMethod() {
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"select").addModifiers(objectArray);
        objectArray = new TypeName[]{this.entityTypeName};
        MethodSpec.Builder builder2 = builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(TableQuery.class), (TypeName[])objectArray));
        objectArray = new Object[]{TableQuery.class, this.tableName, this.entityTypeName};
        MethodSpec methodSpec = builder2.addCode("return new $T<>($S, this.executor, $T.class);", objectArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"build(...)");
        return methodSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MethodSpec> generateShortCutMethods(TableInfo tableInfo) {
        List list;
        Field $this$mapTo$iv$iv;
        Modifier[] $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object item$iv$iv5;
        Iterable destination$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object object;
        Iterator it;
        void $this$mapTo$iv$iv2;
        Object[] $this$map$iv = (Object[])tableInfo.getUniques();
        boolean $i$f$map22 = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv2 : $this$mapTo$iv$iv2) {
            void $this$mapTo$iv$iv3;
            String[] stringArray = (String[])item$iv$iv2;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            void $this$map$iv2 = it;
            boolean $i$f$map = false;
            void var15_38 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(((void)$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            int n = ((void)$this$mapTo$iv$iv3).length;
            for (int i = 0; i < n; ++i) {
                Field field;
                Collection collection2;
                block149: {
                    void item$iv$iv3;
                    void var21_65 = item$iv$iv3 = $this$mapTo$iv$iv3[i];
                    collection2 = destination$iv$iv3;
                    boolean bl2 = false;
                    object = tableInfo.getColumns();
                    int n2 = ((Field[])object).length;
                    for (int j = 0; j < n2; ++j) {
                        void it2;
                        Field field2;
                        Field c = field2 = object[j];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)c.getName(), (Object)it2)) continue;
                        field = field2;
                        break block149;
                    }
                    field = null;
                }
                if (field == null) {
                    return CollectionsKt.emptyList();
                }
                collection2.add(field);
            }
            collection.add((List)destination$iv$iv3);
        }
        List uniqueColumns = (List)destination$iv$iv2;
        Iterable $i$f$map22 = uniqueColumns;
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv2 = $this$mapNotNull$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            MethodSpec it$iv$iv;
            void $this$mapTo$iv$iv4;
            Object item$iv$iv42;
            void $this$mapTo$iv$iv5;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            List it3 = (List)element$iv$iv;
            boolean bl4 = false;
            Iterable $this$map$iv3 = it3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv3;
            Object destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv42 : $this$mapTo$iv$iv5) {
                TypeName typeName;
                void c;
                object = (Field)item$iv$iv42;
                Collection collection = destination$iv$iv5;
                boolean bl5 = false;
                void $this$JavaType$iv = c;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                    if ($this$JavaType$iv.getLength() == 1L) {
                        TypeName typeName2 = ClassName.BOOLEAN.box();
                        typeName = typeName2;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName2, (String)"box(...)");
                    } else {
                        ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                        typeName = (TypeName)arrayTypeName;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv;
                    if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                        TypeName typeName3 = ClassName.BOOLEAN.box();
                        typeName = typeName3;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"box(...)");
                    } else {
                        TypeName typeName4 = ClassName.INT.box();
                        typeName = typeName4;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName4, (String)"box(...)");
                    }
                } else {
                    Object[] thirdChar$iv = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])thirdChar$iv).contains($this$JavaType$iv.getDbType())) {
                        TypeName typeName5 = ClassName.INT.box();
                        typeName = typeName5;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName5, (String)"box(...)");
                    } else {
                        thirdChar$iv = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])thirdChar$iv).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                TypeName typeName6 = ClassName.LONG.box();
                                typeName = typeName6;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName6, (String)"box(...)");
                            } else {
                                TypeName typeName7 = ClassName.INT.box();
                                typeName = typeName7;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName7, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                ClassName className = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                typeName = (TypeName)className;
                            } else {
                                TypeName typeName8 = ClassName.LONG.box();
                                typeName = typeName8;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName8, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                            TypeName typeName9 = ClassName.FLOAT.box();
                            typeName = typeName9;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName9, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                            TypeName typeName10 = ClassName.DOUBLE.box();
                            typeName = typeName10;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName10, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                            ClassName className = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                            ClassName className = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                            ClassName className = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                            ClassName className = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else {
                            thirdChar$iv = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])thirdChar$iv).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getBinary()) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName = (TypeName)arrayTypeName;
                                } else {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName = (TypeName)className;
                                }
                            } else {
                                thirdChar$iv = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])thirdChar$iv).contains($this$JavaType$iv.getDbType())) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName = (TypeName)arrayTypeName;
                                } else {
                                    thirdChar$iv = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])thirdChar$iv).contains($this$JavaType$iv.getDbType())) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName = (TypeName)className;
                                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName = (TypeName)className;
                                    } else {
                                        throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                collection.add(ParameterSpec.builder((TypeName)typeName, (String)StringExtensionKt.getPascalName(c.getName()), (Modifier[])new Modifier[0]).build());
            }
            List parameters = (List)destination$iv$iv5;
            Modifier[] $this$map$iv4 = (Modifier[])it3;
            boolean $i$f$map3 = false;
            destination$iv$iv5 = $this$map$iv4;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            item$iv$iv42 = $this$mapTo$iv$iv4.iterator();
            while (item$iv$iv42.hasNext()) {
                void c;
                item$iv$iv5 = item$iv$iv42.next();
                Field bl5 = (Field)item$iv$iv5;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                Object[] $i$f$getJavaType = new Object[]{Expression.class};
                collection.add(CodeBlock.of((String)("where(" + this.getClassName() + '.' + StringExtensionKt.getPascalName(c.getName()) + ".eq($T.arg(" + StringExtensionKt.getPascalName(c.getName()) + ")))"), (Object[])$i$f$getJavaType));
            }
            List whereCodeSegments = (List)destination$iv$iv;
            $this$map$iv4 = new Modifier[]{Modifier.PUBLIC};
            if (MethodSpec.methodBuilder((String)("findBy" + CollectionsKt.joinToString$default((Iterable)it3, (CharSequence)"And", null, null, (int)0, null, GeneratedTableFile::generateShortCutMethods$lambda$9$lambda$8, (int)30, null))).addAnnotation(Nullable.class).addModifiers($this$map$iv4).returns((TypeName)this.entityTypeName).addParameters((Iterable)parameters).addCode("return this.select().", new Object[0]).addCode(CodeBlock.join((Iterable)whereCodeSegments, (String)".")).addCode(".findOne();", new Object[0]).build() == null) continue;
            boolean bl7 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        List findMethods = (List)destination$iv$iv4;
        Iterable $i$f$mapNotNull22 = uniqueColumns;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv4 = $this$mapNotNull$iv;
        Object[] destination$iv$iv6 = (Object[])new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv22 = $this$mapNotNullTo$iv$iv;
        int $i$f$forEach2 = 0;
        Object element$iv$iv$iv = $this$forEach$iv$iv$iv22.iterator();
        while (element$iv$iv$iv.hasNext()) {
            MethodSpec it$iv$iv;
            Collection collection;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = element$iv$iv$iv.next();
            boolean bl = false;
            List it4 = (List)element$iv$iv;
            boolean bl8 = false;
            Iterable $this$map$iv5 = it4;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv4 = $this$map$iv5;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv5 : $this$mapTo$iv$iv4) {
                TypeName typeName;
                void c;
                Field field = (Field)item$iv$iv5;
                collection = destination$iv$iv;
                boolean bl9 = false;
                void $this$JavaType$iv = c;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bit")) {
                    if ($this$JavaType$iv.getLength() == 1L) {
                        TypeName typeName11 = ClassName.BOOLEAN.box();
                        typeName = typeName11;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName11, (String)"box(...)");
                    } else {
                        ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                        typeName = (TypeName)arrayTypeName;
                    }
                } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv;
                    if ($this$JavaType$iv.getLength() == 1L && $this$JavaType$iv.getName().length() > 2 && StringsKt.startsWith$default((String)$this$JavaType$iv.getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = $this$JavaType$iv.getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                        TypeName typeName12 = ClassName.BOOLEAN.box();
                        typeName = typeName12;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName12, (String)"box(...)");
                    } else {
                        TypeName typeName13 = ClassName.INT.box();
                        typeName = typeName13;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName13, (String)"box(...)");
                    }
                } else {
                    Object[] objectArray2 = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                        TypeName typeName14 = ClassName.INT.box();
                        typeName = typeName14;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName14, (String)"box(...)");
                    } else {
                        objectArray2 = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                TypeName typeName15 = ClassName.LONG.box();
                                typeName = typeName15;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName15, (String)"box(...)");
                            } else {
                                TypeName typeName16 = ClassName.INT.box();
                                typeName = typeName16;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName16, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"bigint")) {
                            if ($this$JavaType$iv.getUnsigned()) {
                                ClassName className = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                typeName = (TypeName)className;
                            } else {
                                TypeName typeName17 = ClassName.LONG.box();
                                typeName = typeName17;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName17, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"float")) {
                            TypeName typeName18 = ClassName.FLOAT.box();
                            typeName = typeName18;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName18, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"double")) {
                            TypeName typeName19 = ClassName.DOUBLE.box();
                            typeName = typeName19;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName19, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"decimal")) {
                            ClassName className = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"date")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"datetime")) {
                            ClassName className = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"timestamp")) {
                            ClassName className = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"time")) {
                            ClassName className = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"year")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else {
                            objectArray2 = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                                if ($this$JavaType$iv.getBinary()) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName = (TypeName)arrayTypeName;
                                } else {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName = (TypeName)className;
                                }
                            } else {
                                objectArray2 = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName = (TypeName)arrayTypeName;
                                } else {
                                    objectArray2 = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])objectArray2).contains($this$JavaType$iv.getDbType())) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName = (TypeName)className;
                                    } else if (Intrinsics.areEqual((Object)$this$JavaType$iv.getDbType(), (Object)"var_string")) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName = (TypeName)className;
                                    } else {
                                        throw new Exception("db[" + $this$JavaType$iv.getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                collection.add(ParameterSpec.builder((TypeName)typeName, (String)StringExtensionKt.getPascalName(c.getName()), (Modifier[])new Modifier[0]).build());
            }
            List parameters = (List)destination$iv$iv;
            Iterable $this$map$iv6 = it4;
            boolean $i$f$map4 = false;
            destination$iv$iv = $this$map$iv6;
            Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
            boolean $i$f$mapTo6 = false;
            item$iv$iv5 = $this$mapTo$iv$iv.iterator();
            while (item$iv$iv5.hasNext()) {
                void c;
                Object item$iv$iv6 = item$iv$iv5.next();
                Field bl9 = (Field)item$iv$iv6;
                collection = destination$iv$iv7;
                boolean bl10 = false;
                Object[] objectArray3 = new Object[]{Expression.class};
                collection.add(CodeBlock.of((String)("where(" + this.getClassName() + '.' + StringExtensionKt.getPascalName(c.getName()) + ".eq($T.arg(" + StringExtensionKt.getPascalName(c.getName()) + ")))"), (Object[])objectArray3));
            }
            List whereCodeSegments = (List)destination$iv$iv7;
            Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
            if (MethodSpec.methodBuilder((String)("deleteBy" + CollectionsKt.joinToString$default((Iterable)it4, (CharSequence)"And", null, null, (int)0, null, GeneratedTableFile::generateShortCutMethods$lambda$13$lambda$12, (int)30, null))).addModifiers(modifierArray).returns(ClassName.BOOLEAN).addParameters((Iterable)parameters).addCode("return this.delete().", new Object[0]).addCode(CodeBlock.join((Iterable)whereCodeSegments, (String)".")).addCode(".execute() > 0;", new Object[0]).build() == null) continue;
            boolean bl11 = false;
            destination$iv$iv6.add(it$iv$iv);
        }
        List deleteMethods = (List)destination$iv$iv6;
        if (!((Collection)uniqueColumns).isEmpty()) {
            MethodSpec.Builder builder;
            Object generatedColumn;
            MethodSpec.Builder saveWithOptionsMethod;
            block150: {
                Object object2;
                $this$mapNotNullTo$iv$iv = new Modifier[]{Modifier.PUBLIC};
                saveWithOptionsMethod = MethodSpec.methodBuilder((String)"save").addAnnotation(Nullable.class).addModifiers($this$mapNotNullTo$iv$iv).returns((TypeName)this.entityTypeName).addParameter((TypeName)this.entityTypeName, "entity", new Modifier[0]).addParameter(ClassName.INT, "options", new Modifier[0]);
                Field[] $i$f$mapNotNullTo22 = tableInfo.getColumns();
                $i$f$forEach2 = $i$f$mapNotNullTo22.length;
                for (int $this$forEach$iv$iv$iv22 = 0; $this$forEach$iv$iv$iv22 < $i$f$forEach2; ++$this$forEach$iv$iv$iv22) {
                    Object it5 = element$iv$iv$iv = $i$f$mapNotNullTo22[$this$forEach$iv$iv$iv22];
                    boolean bl = false;
                    if (!((Field)it5).isAutoIncrement()) continue;
                    object2 = element$iv$iv$iv;
                    break block150;
                }
                object2 = generatedColumn = null;
            }
            if (generatedColumn != null) {
                TypeName typeName;
                destination$iv$iv6 = new Object[1];
                Object $this$JavaType$iv = generatedColumn;
                boolean $i$f$getJavaType = false;
                if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"bit")) {
                    if (((Field)$this$JavaType$iv).getLength() == 1L) {
                        TypeName typeName20 = ClassName.BOOLEAN.box();
                        typeName = typeName20;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName20, (String)"box(...)");
                    } else {
                        ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                        typeName = (TypeName)arrayTypeName;
                    }
                } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"tinyint")) {
                    char thirdChar$iv;
                    if (((Field)$this$JavaType$iv).getLength() == 1L && ((Field)$this$JavaType$iv).getName().length() > 2 && StringsKt.startsWith$default((String)((Field)$this$JavaType$iv).getName(), (String)"is", (boolean)false, (int)2, null) && ((thirdChar$iv = ((Field)$this$JavaType$iv).getName().charAt(2)) == '_' || thirdChar$iv == '-' || Character.isUpperCase(thirdChar$iv))) {
                        TypeName typeName21 = ClassName.BOOLEAN.box();
                        typeName = typeName21;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName21, (String)"box(...)");
                    } else {
                        TypeName typeName22 = ClassName.INT.box();
                        typeName = typeName22;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName22, (String)"box(...)");
                    }
                } else {
                    Object[] thirdChar$iv = new String[]{"smallint", "mediumint"};
                    if (CollectionsKt.listOf((Object[])thirdChar$iv).contains(((Field)$this$JavaType$iv).getDbType())) {
                        TypeName typeName23 = ClassName.INT.box();
                        typeName = typeName23;
                        Intrinsics.checkNotNullExpressionValue((Object)typeName23, (String)"box(...)");
                    } else {
                        thirdChar$iv = new String[]{"int", "integer"};
                        if (CollectionsKt.listOf((Object[])thirdChar$iv).contains(((Field)$this$JavaType$iv).getDbType())) {
                            if (((Field)$this$JavaType$iv).getUnsigned()) {
                                TypeName typeName24 = ClassName.LONG.box();
                                typeName = typeName24;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName24, (String)"box(...)");
                            } else {
                                TypeName typeName25 = ClassName.INT.box();
                                typeName = typeName25;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName25, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"bigint")) {
                            if (((Field)$this$JavaType$iv).getUnsigned()) {
                                ClassName className = ClassName.get(BigInteger.class);
                                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                typeName = (TypeName)className;
                            } else {
                                TypeName typeName26 = ClassName.LONG.box();
                                typeName = typeName26;
                                Intrinsics.checkNotNullExpressionValue((Object)typeName26, (String)"box(...)");
                            }
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"float")) {
                            TypeName typeName27 = ClassName.FLOAT.box();
                            typeName = typeName27;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName27, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"double")) {
                            TypeName typeName28 = ClassName.DOUBLE.box();
                            typeName = typeName28;
                            Intrinsics.checkNotNullExpressionValue((Object)typeName28, (String)"box(...)");
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"decimal")) {
                            ClassName className = ClassName.get(BigDecimal.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"date")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"datetime")) {
                            ClassName className = ClassName.get(LocalDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"timestamp")) {
                            ClassName className = ClassName.get(OffsetDateTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"time")) {
                            ClassName className = ClassName.get(LocalTime.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"year")) {
                            ClassName className = ClassName.get(LocalDate.class);
                            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                            typeName = (TypeName)className;
                        } else {
                            thirdChar$iv = new String[]{"char", "varchar"};
                            if (CollectionsKt.listOf((Object[])thirdChar$iv).contains(((Field)$this$JavaType$iv).getDbType())) {
                                if (((Field)$this$JavaType$iv).getBinary()) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName = (TypeName)arrayTypeName;
                                } else {
                                    ClassName className = ClassName.get(String.class);
                                    Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                    typeName = (TypeName)className;
                                }
                            } else {
                                thirdChar$iv = new String[]{"binary", "varbinary", "tinyblob", "blob", "mediumblob", "longblob"};
                                if (CollectionsKt.listOf((Object[])thirdChar$iv).contains(((Field)$this$JavaType$iv).getDbType())) {
                                    ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)ClassName.BYTE);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(...)");
                                    typeName = (TypeName)arrayTypeName;
                                } else {
                                    thirdChar$iv = new String[]{"tinytext", "text", "mediumtext", "longtext", "enum", "set"};
                                    if (CollectionsKt.listOf((Object[])thirdChar$iv).contains(((Field)$this$JavaType$iv).getDbType())) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName = (TypeName)className;
                                    } else if (Intrinsics.areEqual((Object)((Field)$this$JavaType$iv).getDbType(), (Object)"var_string")) {
                                        ClassName className = ClassName.get(String.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
                                        typeName = (TypeName)className;
                                    } else {
                                        throw new Exception("db[" + ((Field)$this$JavaType$iv).getDbType() + "] -> java \u6620\u5c04\u5931\u8d25!!!");
                                    }
                                }
                            }
                        }
                    }
                }
                destination$iv$iv6[0] = typeName;
                saveWithOptionsMethod.addCode("$T generatedColumnValue = this.insert(entity, options);\n", destination$iv$iv6);
                builder = saveWithOptionsMethod.addCode("if(generatedColumnValue != null) entity.set" + StringExtensionKt.getPascalName(((Field)generatedColumn).getName()) + "(generatedColumnValue);\n", new Object[0]);
            } else {
                builder = saveWithOptionsMethod.addCode("this.insert(entity, options);\n", new Object[0]);
            }
            Iterable $this$forEach$iv = uniqueColumns;
            boolean $i$f$forEach222 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv6;
                List it6 = (List)element$iv;
                boolean bl = false;
                Iterable $this$map$iv7 = it6;
                boolean $i$f$map = false;
                Iterable it4 = $this$map$iv7;
                Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
                boolean $i$f$mapTo7 = false;
                for (Object item$iv$iv7 : $this$mapTo$iv$iv6) {
                    void c;
                    $this$mapTo$iv$iv = (Field)item$iv$iv7;
                    Collection collection = destination$iv$iv8;
                    boolean bl12 = false;
                    collection.add("entity.get" + StringExtensionKt.getPascalName(c.getName()) + "()");
                }
                List fieldGetters = (List)destination$iv$iv8;
                String condition = CollectionsKt.joinToString$default((Iterable)fieldGetters, (CharSequence)" && ", null, null, (int)0, null, GeneratedTableFile::generateShortCutMethods$lambda$18$lambda$16, (int)30, null);
                String findMethodName = "findBy" + CollectionsKt.joinToString$default((Iterable)it6, (CharSequence)"And", null, null, (int)0, null, GeneratedTableFile::generateShortCutMethods$lambda$18$lambda$17, (int)30, null);
                String parameters = CollectionsKt.joinToString$default((Iterable)fieldGetters, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                saveWithOptionsMethod.addCode("if(" + condition + ") return this." + findMethodName + '(' + parameters + ");\n", new Object[0]);
            }
            saveWithOptionsMethod.addCode("return null;", new Object[0]);
            Object[] $i$f$forEach222 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec.Builder builder2 = MethodSpec.methodBuilder((String)"save").addAnnotation(Nullable.class).addModifiers($i$f$forEach222).returns((TypeName)this.entityTypeName).addParameter((TypeName)this.entityTypeName, "entity", new Modifier[0]);
            $i$f$forEach222 = new Object[]{InsertOption.class};
            MethodSpec.Builder saveMethod = builder2.addCode("return this.save(entity, $T.NULL_IS_NONE);", $i$f$forEach222);
            Object[] objectArray4 = new Modifier[]{Modifier.PUBLIC};
            MethodSpec.Builder builder3 = MethodSpec.methodBuilder((String)"saveOrUpdate").addAnnotation(Nullable.class).addModifiers(objectArray4).returns((TypeName)this.entityTypeName).addParameter((TypeName)this.entityTypeName, "entity", new Modifier[0]);
            objectArray4 = new Object[]{InsertOption.class, InsertOption.class};
            MethodSpec.Builder saveOrUpdateMethod = builder3.addCode("return this.save(entity, $T.NULL_IS_NONE | $T.INSERT_OR_UPDATE);", objectArray4);
            objectArray4 = new MethodSpec[]{saveWithOptionsMethod.build(), saveMethod.build(), saveOrUpdateMethod.build()};
            list = CollectionsKt.listOf((Object[])objectArray4);
        } else {
            list = CollectionsKt.emptyList();
        }
        List saveMethods = list;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)findMethods, (Iterable)deleteMethods), (Iterable)saveMethods);
    }

    private static final CharSequence generateShortCutMethods$lambda$9$lambda$8(Field c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return StringExtensionKt.getPascalName(c.getName());
    }

    private static final CharSequence generateShortCutMethods$lambda$13$lambda$12(Field c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return StringExtensionKt.getPascalName(c.getName());
    }

    private static final CharSequence generateShortCutMethods$lambda$18$lambda$16(String getter) {
        Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
        return getter + " != null";
    }

    private static final CharSequence generateShortCutMethods$lambda$18$lambda$17(Field c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return StringExtensionKt.getPascalName(c.getName());
    }
}

