/*
 * Decompiled with CFR 0.152.
 */
package me.danwi.sqlex.parser.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import me.danwi.sqlex.parser.exception.SqlExRepositoryException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\",\u0010\u0004\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\b\u0010\u0003\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\",\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\b\u0010\u0003\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u000f"}, d2={"SelfCacheHashExt", "", "SourceCacheHashExt", "value", "selfCacheHash", "Ljava/io/File;", "getSelfCacheHash", "(Ljava/io/File;)Ljava/lang/String;", "setSelfCacheHash", "(Ljava/io/File;Ljava/lang/String;)V", "sourceCacheHash", "getSourceCacheHash", "setSourceCacheHash", "computeCacheHash", "getComputeCacheHash", "parser"})
@SourceDebugExtension(value={"SMAP\nFileExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileExtension.kt\nme/danwi/sqlex/parser/util/FileExtensionKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,85:1\n608#2:86\n*S KotlinDebug\n*F\n+ 1 FileExtension.kt\nme/danwi/sqlex/parser/util/FileExtensionKt\n*L\n64#1:86\n*E\n"})
public final class FileExtensionKt {
    @NotNull
    private static final String SelfCacheHashExt = "self.cache";
    @NotNull
    private static final String SourceCacheHashExt = "source.cache";

    @Nullable
    public static final String getSelfCacheHash(@NotNull File $this$selfCacheHash) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$selfCacheHash, (String)"<this>");
        try {
            if (!$this$selfCacheHash.isDirectory()) {
                return null;
            }
            String[] stringArray = new String[]{FilesKt.getNameWithoutExtension((File)$this$selfCacheHash) + '.' + SelfCacheHashExt};
            File file = Paths.get($this$selfCacheHash.getParentFile().getAbsolutePath(), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            string = FilesKt.readText$default((File)file, null, (int)1, null);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public static final void setSelfCacheHash(@NotNull File $this$selfCacheHash, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$selfCacheHash, (String)"<this>");
        if (value == null) {
            return;
        }
        String[] stringArray = new String[]{FilesKt.getNameWithoutExtension((File)$this$selfCacheHash) + '.' + SelfCacheHashExt};
        File file = Paths.get($this$selfCacheHash.getParentFile().getAbsolutePath(), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.writeText$default((File)file, (String)value, null, (int)2, null);
    }

    @Nullable
    public static final String getSourceCacheHash(@NotNull File $this$sourceCacheHash) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$sourceCacheHash, (String)"<this>");
        try {
            if (!$this$sourceCacheHash.isDirectory()) {
                return null;
            }
            String[] stringArray = new String[]{FilesKt.getNameWithoutExtension((File)$this$sourceCacheHash) + '.' + SourceCacheHashExt};
            File file = Paths.get($this$sourceCacheHash.getParentFile().getAbsolutePath(), stringArray).toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            string = FilesKt.readText$default((File)file, null, (int)1, null);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public static final void setSourceCacheHash(@NotNull File $this$sourceCacheHash, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)$this$sourceCacheHash, (String)"<this>");
        if (value == null) {
            return;
        }
        String[] stringArray = new String[]{FilesKt.getNameWithoutExtension((File)$this$sourceCacheHash) + '.' + SourceCacheHashExt};
        File file = Paths.get($this$sourceCacheHash.getParentFile().getAbsolutePath(), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.writeText$default((File)file, (String)value, null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String getComputeCacheHash(@NotNull File $this$computeCacheHash) {
        Intrinsics.checkNotNullParameter((Object)$this$computeCacheHash, (String)"<this>");
        if (!$this$computeCacheHash.isDirectory()) {
            throw new SqlExRepositoryException("\u8def\u5f84\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939: " + $this$computeCacheHash.getAbsolutePath());
        }
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)$this$computeCacheHash, null, (int)1, null)), FileExtensionKt::_get_computeCacheHash_$lambda$0), FileExtensionKt::_get_computeCacheHash_$lambda$1);
        boolean $i$f$sortedBy22 = false;
        Sequence allFiles = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getAbsolutePath());
                it = (File)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getAbsolutePath())));
            }
        });
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String $i$f$sortedBy22 = "0.19.252";
        byte[] byArray = $i$f$sortedBy22.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        digest.update(byArray);
        byte[] buf = new byte[1024];
        for (File file : allFiles) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Object object = string;
            byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            digest.update(byArray2);
            object = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int n;
                FileInputStream it = (FileInputStream)object;
                boolean bl = false;
                while ((n = it.read(buf)) != -1) {
                    digest.update(buf, 0, n);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        byte[] byArray3 = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray3, (CharSequence)"", null, null, (int)0, null, FileExtensionKt::_get_computeCacheHash_$lambda$4, (int)30, null);
    }

    private static final boolean _get_computeCacheHash_$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getName(), (Object)SelfCacheHashExt) && !Intrinsics.areEqual((Object)it.getName(), (Object)SourceCacheHashExt);
    }

    private static final boolean _get_computeCacheHash_$lambda$1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final CharSequence _get_computeCacheHash_$lambda$4(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

