/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.jms;

import java.util.HashMap;
import java.util.Map;

public final class JmsPropertyContext {
    private static final String TYPE = "ae5dbae8-13b5-40f5-a852-065b67755a29";
    private static final String CORRELATIONID = "36da23de-e9a2-4ae7-927b-03a852bc312f";
    private static final JmsPropertyContext CONTEXT = new JmsPropertyContext();
    private final ThreadLocal<Map<String, String>> jmsProperties = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<Map<String, String>> appProperties = ThreadLocal.withInitial(HashMap::new);

    private JmsPropertyContext() {
    }

    private static Map<String, String> jmsMap() {
        return JmsPropertyContext.CONTEXT.jmsProperties.get();
    }

    private static Map<String, String> appMap() {
        return JmsPropertyContext.CONTEXT.appProperties.get();
    }

    public static void clearAll() {
        JmsPropertyContext.jmsMap().clear();
        JmsPropertyContext.appMap().clear();
    }

    public static void setJmsType(String type) {
        JmsPropertyContext.jmsMap().put(TYPE, type);
    }

    public static String getJmsType() {
        return JmsPropertyContext.jmsMap().get(TYPE);
    }

    public static void setJmsCorrelationId(String id) {
        JmsPropertyContext.jmsMap().put(CORRELATIONID, id);
    }

    public static String getJmsCorrelationId() {
        return JmsPropertyContext.jmsMap().get(CORRELATIONID);
    }

    public static void clearJmsProperties() {
        JmsPropertyContext.jmsMap().clear();
    }

    public static void setAppProperty(String name, String value) {
        JmsPropertyContext.appMap().put(name, value);
    }

    public static String getAppProperty(String name) {
        return JmsPropertyContext.appMap().get(name);
    }

    public static void removeAppProperty(String name) {
        JmsPropertyContext.appMap().remove(name);
    }

    public static void clearAppProperties() {
        JmsPropertyContext.appMap().clear();
    }
}

