/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.ehp246.aufjms.api.endpoint.AtEndpoint;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableResolver;
import me.ehp246.aufjms.api.jms.ReplyToNameSupplier;
import me.ehp246.aufjms.api.spi.FromJson;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class ReplyEndpointConfiguration {
    private final ConcurrentMap<String, Executable> correlMap = new ConcurrentHashMap<String, Executable>();
    private final AtEndpoint msgEndpoint;
    private final long timeout;
    private final long ttl;
    private final ReplyToNameSupplier replyToNameSupplier;
    private final FromJson fromBody;

    public ReplyEndpointConfiguration(ReplyToNameSupplier replyTo, FromJson fromBody, @Value(value="${me.ehp246.aufjms.timeout:30000}") long timeout, @Value(value="${me.ehp246.aufjms.ttl:0}") long ttl) {
        this.timeout = timeout;
        this.ttl = ttl;
        this.replyToNameSupplier = replyTo;
        this.fromBody = fromBody;
        this.msgEndpoint = new AtEndpoint(){

            @Override
            public String getDestinationName() {
                return ReplyEndpointConfiguration.this.getReplyToName();
            }

            @Override
            public ExecutableResolver getResolver() {
                return msg -> (Executable)ReplyEndpointConfiguration.this.correlMap.get(msg.correlationId());
            }
        };
    }

    public Map<String, Executable> getCorrelMap() {
        return this.correlMap;
    }

    @Bean
    public AtEndpoint getReplyEndpoint() {
        return this.msgEndpoint;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getTtl() {
        return this.ttl;
    }

    public String getReplyToName() {
        return this.replyToNameSupplier.get();
    }

    public FromJson getFromBody() {
        return this.fromBody;
    }
}

