/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Set;
import java.util.concurrent.Executor;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.endpoint.AtEndpoint;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.jms.DestinationNameResolver;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.endpoint.DefaultEndpointConsumer;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;

public final class AtEndpointConfigurer
implements JmsListenerConfigurer {
    private static final Logger LOGGER = LogManager.getLogger(AtEndpointConfigurer.class);
    private final JmsListenerContainerFactory<DefaultMessageListenerContainer> listenerContainerFactory;
    private final Set<AtEndpoint> endpoints;
    private final DestinationNameResolver destintationNameResolver;
    private final Executor executor;
    private final ExecutableBinder binder;

    public AtEndpointConfigurer(JmsListenerContainerFactory<DefaultMessageListenerContainer> listenerContainerFactory, Set<AtEndpoint> endpoints, DestinationNameResolver destintationNameResolver, @Qualifier(value="c2992a60-8357-441a-8b85-ebacf8182236") Executor actionExecutor, ExecutableBinder binder) {
        this.listenerContainerFactory = listenerContainerFactory;
        this.endpoints = endpoints;
        this.destintationNameResolver = destintationNameResolver;
        this.executor = actionExecutor;
        this.binder = binder;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar registrar) {
        this.endpoints.stream().forEach(endpoint -> {
            LOGGER.atDebug().log("Registering endpoint on destination '{}'", (Object)endpoint.getDestinationName());
            DefaultEndpointConsumer defaultMsgDispatcher = new DefaultEndpointConsumer(endpoint.getResolver(), this.binder, this.executor);
            String id = endpoint.getDestinationName() + "@" + AtEndpoint.class.getCanonicalName();
            registrar.registerEndpoint(new JmsListenerEndpoint(){
                final /* synthetic */ AtEndpoint val$endpoint;
                final /* synthetic */ DefaultEndpointConsumer val$defaultMsgDispatcher;
                final /* synthetic */ String val$id;
                {
                    this.val$endpoint = atEndpoint;
                    this.val$defaultMsgDispatcher = defaultEndpointConsumer;
                    this.val$id = string;
                }

                public void setupListenerContainer(MessageListenerContainer listenerContainer) {
                    AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
                    container.setDestinationName(this.val$endpoint.getDestinationName());
                    container.setDestinationResolver((session, destinationName, pubSubDomain) -> AtEndpointConfigurer.this.destintationNameResolver.resolve("", destinationName));
                    container.setupMessageListener(message -> {
                        JmsMsg msg = TextJmsMsg.from((TextMessage)message);
                        ThreadContext.put((String)"AufJms-Msg-Type", (String)msg.type());
                        ThreadContext.put((String)"AufJms-Correlation-Id", (String)msg.correlationId());
                        this.val$defaultMsgDispatcher.accept(msg);
                        ThreadContext.remove((String)"AufJms-Msg-Type");
                        ThreadContext.remove((String)"AufJms-Correlation-Id");
                    });
                }

                public String getId() {
                    return this.val$id;
                }
            }, this.listenerContainerFactory);
        });
    }
}

