/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import me.ehp246.aufjms.api.endpoint.EndpointConsumer;
import me.ehp246.aufjms.api.endpoint.Executable;
import me.ehp246.aufjms.api.endpoint.ExecutableBinder;
import me.ehp246.aufjms.api.endpoint.ExecutableResolver;
import me.ehp246.aufjms.api.endpoint.ExecutedInstance;
import me.ehp246.aufjms.api.endpoint.InvocationModel;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.reflection.CatchingInvocation;
import me.ehp246.aufjms.core.reflection.InvocationOutcome;
import me.ehp246.aufjms.core.reflection.ReflectingInvocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Qualifier;

public final class DefaultEndpointConsumer
implements EndpointConsumer {
    private static final Logger LOGGER = LogManager.getLogger(DefaultEndpointConsumer.class);
    private final Executor executor;
    private final ExecutableResolver actionResolver;
    private final ExecutableBinder binder;

    public DefaultEndpointConsumer(ExecutableResolver actionResolver, ExecutableBinder binder, @Qualifier(value="c2992a60-8357-441a-8b85-ebacf8182236") Executor executor) {
        this.actionResolver = actionResolver;
        this.binder = binder;
        this.executor = executor;
    }

    @Override
    public void accept(JmsMsg msg) {
        LOGGER.atTrace().log("Dispatching");
        InvocationOutcome<Executable> resolveOutcome = CatchingInvocation.invoke(() -> this.actionResolver.resolve(msg));
        if (resolveOutcome.hasThrown()) {
            LOGGER.atError().log("Resolution failed", (Object)resolveOutcome.getThrown());
            return;
        }
        Executable target = resolveOutcome.getReturned();
        if (target == null) {
            LOGGER.atInfo().log("Un-matched message {} {}", (Object)msg.id(), (Object)msg.correlationId());
            return;
        }
        LOGGER.atTrace().log("Submitting");
        Runnable runnable = DefaultEndpointConsumer.newRunnable(msg, target, this.binder);
        if (target.getInvocationModel() == null || target.getInvocationModel() == InvocationModel.SYNC) {
            LOGGER.atTrace().log("Executing");
            runnable.run();
            LOGGER.atTrace().log("Executed");
        } else {
            this.executor.execute(() -> {
                ThreadContext.put((String)"AufJms-Msg-Type", (String)msg.type());
                ThreadContext.put((String)"AufJms-Correlation-Id", (String)msg.correlationId());
                LOGGER.atTrace().log("Executing");
                runnable.run();
                LOGGER.atTrace().log("Executed");
                ThreadContext.remove((String)"AufJms-Msg-Type");
                ThreadContext.remove((String)"AufJms-Correlation-Id");
            });
        }
    }

    private static Runnable newRunnable(final JmsMsg msg, final Executable target, ExecutableBinder binder) {
        return () -> {
            InvocationOutcome<ReflectingInvocation> bindOutcome = CatchingInvocation.invoke(() -> binder.bind(target, () -> msg));
            final InvocationOutcome outcome = bindOutcome.ifReturnedPresent().map(ReflectingInvocation::invoke).orElseGet(() -> InvocationOutcome.thrown(bindOutcome.getThrown()));
            Consumer<ExecutedInstance> postEexcution = target.postExecution();
            if (postEexcution == null) {
                return;
            }
            LOGGER.atTrace().log("Executing postExecution");
            postEexcution.accept(new ExecutedInstance(){

                @Override
                public InvocationOutcome<?> getOutcome() {
                    return outcome;
                }

                @Override
                public JmsMsg getMsg() {
                    return msg;
                }

                @Override
                public Executable getInstance() {
                    return target;
                }
            });
            LOGGER.atTrace().log("Executed postExecution");
        };
    }
}

