/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ehp246.aufjms.api.annotation.EnableForJms;
import me.ehp246.aufjms.api.endpoint.AtEndpoint;
import me.ehp246.aufjms.core.endpoint.AtEndpointFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public final class EnableForJmsRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map enablerAttributes = importingClassMetadata.getAnnotationAttributes(EnableForJms.class.getCanonicalName());
        if (enablerAttributes == null) {
            return;
        }
        Stream.of((Object[])enablerAttributes.get("value")).map(attribute -> (Map)attribute).forEach(endpoint -> {
            GenericBeanDefinition beanDefinition = this.getBeanDefinition((Map<String, Object>)endpoint);
            Set<Object> scanThese = null;
            Class[] base = (Class[])endpoint.get("scan");
            if (base.length > 0) {
                scanThese = Stream.of(base).map(baseClass -> baseClass.getPackage().getName()).collect(Collectors.toSet());
            } else {
                String baseName = importingClassMetadata.getClassName();
                scanThese = Set.of(baseName.substring(0, baseName.lastIndexOf(".")));
            }
            String destinationName = endpoint.get("value").toString();
            beanDefinition.setConstructorArgumentValues(this.getParameters(destinationName, scanThese));
            registry.registerBeanDefinition(destinationName + "@" + importingClassMetadata.getClassName(), (BeanDefinition)beanDefinition);
        });
    }

    private GenericBeanDefinition getBeanDefinition(Map<String, Object> annotationAttributes) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(AtEndpoint.class);
        beanDefinition.setFactoryBeanName(AtEndpointFactory.class.getName());
        beanDefinition.setFactoryMethodName("newEndpoint");
        return beanDefinition;
    }

    private ConstructorArgumentValues getParameters(Object destination, Object scans) {
        ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
        constructorArgumentValues.addGenericArgumentValue(destination);
        constructorArgumentValues.addGenericArgumentValue(scans);
        return constructorArgumentValues;
    }
}

