/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.dispatch.DispatchFn;
import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.exception.DispatchFnException;
import me.ehp246.aufjms.api.jms.ConnectionProvider;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.ToJson;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultDispatchFnProvider
implements JmsDispatchFnProvider {
    private static final Logger LOGGER = LogManager.getLogger(DefaultDispatchFnProvider.class);
    private final ConnectionProvider connProvider;
    private final ToJson toJson;
    private final List<DispatchListener> listeners;

    public DefaultDispatchFnProvider(ConnectionProvider cons, ToJson jsonFn, List<DispatchListener> dispatchListeners) {
        this.connProvider = Objects.requireNonNull(cons);
        this.toJson = jsonFn;
        this.listeners = dispatchListeners == null ? List.of() : Collections.unmodifiableList(dispatchListeners);
    }

    @Override
    public DispatchFn get(String connectionName) {
        return dispatch -> {
            LOGGER.atTrace().log("Sending {}:{} to {} ", (Object)dispatch.correlationId(), (Object)dispatch.type(), (Object)dispatch.destination().toString());
            try (Session session = this.connProvider.get(connectionName).createSession(false, 1);){
                JmsMsg jmsMsg;
                block15: {
                    TextMessage message = session.createTextMessage();
                    JmsMsg msg = TextJmsMsg.from(message);
                    message.setText(this.toJson.apply(dispatch.bodyValues()));
                    message.setJMSReplyTo(dispatch.replyTo());
                    message.setJMSType(dispatch.type());
                    message.setJMSCorrelationID(dispatch.correlationId());
                    if (OneUtil.hasValue(dispatch.groupId())) {
                        message.setStringProperty("JMSXGroupID", dispatch.groupId());
                    }
                    message.setIntProperty("JMSXGroupSeq", Optional.ofNullable(dispatch.groupSeq()).map(Integer::intValue).orElse(0).intValue());
                    message.setText(this.toJson.apply(dispatch.bodyValues()));
                    MessageProducer producer = session.createProducer(null);
                    try {
                        producer.setTimeToLive(Optional.ofNullable(dispatch.ttl().toMillis()).orElse(0L).longValue());
                        this.listeners.stream().forEach(listener -> listener.onDispatch(msg));
                        producer.send(dispatch.destination(), (Message)message);
                        LOGGER.atTrace().log("Sent {} ", (Object)dispatch.correlationId());
                        jmsMsg = msg;
                        if (producer == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (producer != null) {
                            try {
                                producer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    producer.close();
                }
                return jmsMsg;
            }
            catch (JMSException e) {
                LOGGER.atError().log("Failed to send: to {}, type {}, correclation id {}", (Object)dispatch.destination().toString(), (Object)dispatch.type(), (Object)dispatch.correlationId(), (Object)e);
                throw new DispatchFnException(e);
            }
        };
    }
}

