/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.jms.Destination;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.dispatch.InvocationDispatchBuilder;
import me.ehp246.aufjms.api.dispatch.JmsDispatch;
import me.ehp246.aufjms.api.jms.DestinationProvider;
import me.ehp246.aufjms.api.jms.Invocation;
import me.ehp246.aufjms.core.reflection.DefaultProxyInvocation;
import me.ehp246.aufjms.core.util.OneUtil;

public final class DefaultInvocationDispatchBuilder
implements InvocationDispatchBuilder {
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = Set.of();
    private final DestinationProvider destinationResolver;

    public DefaultInvocationDispatchBuilder(DestinationProvider destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    @Override
    public JmsDispatch get(final ByJmsProxyConfig config, Invocation invocation) {
        DefaultProxyInvocation proxyInvocation = new DefaultProxyInvocation(invocation.method().getDeclaringClass(), invocation.target(), invocation.method(), invocation.args());
        final Destination destination = this.destinationResolver.get(config.connection(), config.destination());
        final String type = proxyInvocation.resolveAnnotatedValue(OfType.class, arg -> arg.argument() != null ? arg.argument().toString() : (((OfType)arg.annotation()).value().isBlank() ? null : ((OfType)arg.annotation()).value()), ofType -> ofType.value().isBlank() ? OneUtil.firstUpper(proxyInvocation.getMethodName()) : ofType.value(), ofType -> ofType.value().isBlank() ? proxyInvocation.getDeclaringClassSimpleName() : ofType.value(), proxyInvocation::getDeclaringClassSimpleName);
        final Destination replyTo = Optional.ofNullable(config.replyTo()).filter(OneUtil::hasValue).map(name -> this.destinationResolver.get(config.connection(), (String)name)).orElse(null);
        final String correlId = UUID.randomUUID().toString();
        final List<?> bodyValues = Collections.unmodifiableList(proxyInvocation.filterPayloadArgs(PARAMETER_ANNOTATIONS));
        return new JmsDispatch(){

            @Override
            public Destination destination() {
                return destination;
            }

            @Override
            public String type() {
                return type;
            }

            @Override
            public String correlationId() {
                return correlId;
            }

            @Override
            public List<?> bodyValues() {
                return bodyValues;
            }

            @Override
            public Destination replyTo() {
                return replyTo;
            }

            @Override
            public Duration ttl() {
                return config.ttl();
            }

            @Override
            public String groupId() {
                return null;
            }

            @Override
            public Integer groupSeq() {
                return null;
            }
        };
    }
}

