/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.util.List;
import java.util.function.Consumer;
import me.ehp246.aufjms.api.endpoint.ExecutedInstance;
import me.ehp246.aufjms.api.exception.ExecutionThrown;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.jms.MsgPortProvider;
import me.ehp246.aufjms.api.jms.MsgSupplier;
import me.ehp246.aufjms.core.reflection.InvocationOutcome;

public class ReplyExecuted
implements Consumer<ExecutedInstance> {
    private final MsgPortProvider portProvider;

    public ReplyExecuted(MsgPortProvider portProvider) {
        this.portProvider = portProvider;
    }

    @Override
    public void accept(final ExecutedInstance instance) {
        final JmsMsg msg = instance.getMsg();
        if (msg.replyTo() == null) {
            return;
        }
        this.portProvider.get(msg::replyTo).accept(new MsgSupplier(){
            private final InvocationOutcome<?> outcome;
            {
                this.outcome = instance.getOutcome();
            }

            @Override
            public String getType() {
                return msg.type();
            }

            @Override
            public String getCorrelationId() {
                return msg.correlationId();
            }

            @Override
            public List<?> getBodyValues() {
                return this.outcome.hasReturned() ? (this.outcome.getReturned() != null ? List.of(this.outcome.getReturned()) : List.of()) : List.of(new ExecutionThrown(){

                    @Override
                    public Integer getCode() {
                        Throwable thrown = outcome.getThrown();
                        if (thrown instanceof ExecutionThrown) {
                            return ((ExecutionThrown)((Object)thrown)).getCode();
                        }
                        return null;
                    }

                    @Override
                    public String getMessage() {
                        return outcome.getThrown().getMessage();
                    }
                });
            }

            @Override
            public boolean isException() {
                return this.outcome.hasThrown();
            }

            @Override
            public Long getTtl() {
                return null;
            }

            @Override
            public String getGroupId() {
                return msg.groupId();
            }

            @Override
            public String getInvoking() {
                return msg.invoking();
            }
        });
    }
}

