/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.reflection;

import java.util.Optional;

public final class InvocationOutcome<T> {
    private final T returned;
    private final Throwable thrown;
    private final boolean hasReturned;

    private InvocationOutcome(T returned, Throwable thrown, boolean hasReturned) {
        this.returned = returned;
        this.hasReturned = hasReturned;
        this.thrown = thrown;
    }

    public static <T> InvocationOutcome<T> returned(T returned) {
        return new InvocationOutcome<T>(returned, null, true);
    }

    public static <T> InvocationOutcome<T> thrown(Throwable thrown) {
        return new InvocationOutcome<Object>(null, thrown, false);
    }

    public T getReturned() {
        return this.returned;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public boolean hasReturned() {
        return this.hasReturned;
    }

    public boolean hasThrown() {
        return !this.hasReturned;
    }

    public Object outcomeValue() {
        return this.hasReturned() ? this.getReturned() : this.getThrown();
    }

    public Optional<T> ifReturnedPresent() {
        return this.hasReturned() ? Optional.of(this.returned) : Optional.empty();
    }
}

