/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import me.ehp246.aufjms.core.reflection.ArgumentsProvider;
import me.ehp246.aufjms.core.reflection.InvocationOutcome;

public final class ReflectingInvocation {
    private final Object target;
    private final Method method;
    private final Object[] arguments;

    public ReflectingInvocation(Object target, Method method, Object[] arguments) {
        this.target = target;
        this.method = method;
        this.arguments = arguments;
    }

    public static ReflectingInvocation bind(Object target, Method method, ArgumentsProvider provider) {
        return new ReflectingInvocation(target, method, provider.provideFor(method));
    }

    public InvocationOutcome<Object> invoke() {
        try {
            this.method.setAccessible(true);
            return InvocationOutcome.returned(this.method.invoke(this.target, this.arguments));
        }
        catch (InvocationTargetException e) {
            return InvocationOutcome.thrown(e.getCause());
        }
        catch (Exception e) {
            return InvocationOutcome.thrown(e);
        }
    }
}

