/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.util;

import java.time.Instant;
import java.util.concurrent.Callable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import me.ehp246.aufjms.api.exception.JmsException;
import me.ehp246.aufjms.api.jms.JmsMsg;

public final class TextJmsMsg
implements JmsMsg {
    private final TextMessage message;

    private TextJmsMsg(TextMessage message) {
        this.message = message;
    }

    @Override
    public String id() {
        return TextJmsMsg.invoke(() -> ((TextMessage)this.message).getJMSMessageID());
    }

    @Override
    public String type() {
        return TextJmsMsg.invoke(() -> ((TextMessage)this.message).getJMSType());
    }

    @Override
    public String correlationId() {
        return TextJmsMsg.invoke(() -> ((TextMessage)this.message).getJMSCorrelationID());
    }

    @Override
    public Destination replyTo() {
        return TextJmsMsg.invoke(() -> ((TextMessage)this.message).getJMSReplyTo());
    }

    @Override
    public String text() {
        return TextJmsMsg.invoke(() -> ((TextMessage)this.message).getText());
    }

    @Override
    public String groupId() {
        return TextJmsMsg.invoke(() -> this.message.getStringProperty("JMSXGroupID"));
    }

    @Override
    public long expiration() {
        return TextJmsMsg.invoke(() -> ((TextMessage)this.message).getJMSExpiration());
    }

    @Override
    public Destination destination() {
        return TextJmsMsg.invoke(() -> ((TextMessage)this.message).getJMSDestination());
    }

    @Override
    public String invoking() {
        return TextJmsMsg.invoke(() -> this.message.getStringProperty("AufJmsInvoking"));
    }

    @Override
    public <T> T property(String name, Class<T> type) {
        if (type == String.class) {
            return (T)TextJmsMsg.invoke(() -> this.message.getStringProperty(name));
        }
        if (type == Integer.TYPE) {
            return (T)TextJmsMsg.invoke(() -> this.message.getIntProperty(name));
        }
        if (type == Long.TYPE) {
            return (T)TextJmsMsg.invoke(() -> this.message.getLongProperty(name));
        }
        if (type == Boolean.TYPE) {
            return (T)TextJmsMsg.invoke(() -> this.message.getBooleanProperty(name));
        }
        throw new RuntimeException("Un-supported property type " + type.getTypeName());
    }

    @Override
    public Instant timestamp() {
        return Instant.ofEpochMilli(TextJmsMsg.invoke(() -> ((TextMessage)this.message).getJMSTimestamp()));
    }

    @Override
    public TextMessage message() {
        return this.message;
    }

    public static JmsMsg from(TextMessage message) {
        return new TextJmsMsg(message);
    }

    private static <V> V invoke(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (e instanceof JMSException) {
                throw new JmsException((JMSException)((Object)e));
            }
            throw new RuntimeException(e);
        }
    }
}

