/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.endpoint;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ehp246.aufjms.api.annotation.ForJms;
import me.ehp246.aufjms.api.annotation.Invoking;
import me.ehp246.aufjms.api.endpoint.InstanceScope;
import me.ehp246.aufjms.api.endpoint.InvocationModel;
import me.ehp246.aufjms.api.endpoint.InvokableDefinition;
import me.ehp246.aufjms.api.endpoint.InvokableRegistry;
import me.ehp246.aufjms.api.endpoint.InvokableResolver;
import me.ehp246.aufjms.api.endpoint.ResolvedInstanceType;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.reflection.ReflectingType;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.StreamOf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

final class DefaultInvokableResolver
implements InvokableRegistry,
InvokableResolver {
    private static final Logger LOGGER = LogManager.getLogger(DefaultInvokableResolver.class);
    private final Map<String, InvokableDefinition> registeredInvokables = new HashMap<String, InvokableDefinition>();
    private final Map<Class<?>, Map<String, Method>> registereMethods = new HashMap();

    DefaultInvokableResolver() {
    }

    public DefaultInvokableResolver register(Stream<InvokableDefinition> invokingDefinitions) {
        invokingDefinitions.forEach(this::register);
        return this;
    }

    @Override
    public void register(InvokableDefinition invokingDefinition) {
        InvokableDefinition registered = this.registeredInvokables.putIfAbsent(invokingDefinition.getMsgType(), invokingDefinition);
        if (registered != null) {
            throw new RuntimeException("Duplicate type " + registered.getMsgType() + " from " + registered.getInstanceType());
        }
        this.registereMethods.put(invokingDefinition.getInstanceType(), invokingDefinition.getMethods());
    }

    @Override
    public List<InvokableDefinition> getRegistered() {
        return this.registeredInvokables.values().stream().collect(Collectors.toList());
    }

    @Override
    public ResolvedInstanceType resolve(JmsMsg msg) {
        String msgType = OneUtil.toString(Objects.requireNonNull(msg).type(), "");
        final InvokableDefinition definition = this.registeredInvokables.get(msgType);
        if (definition == null) {
            LOGGER.atTrace().log("Type {} not found", (Object)msgType);
            return null;
        }
        String invoking = msg.invoking();
        invoking = invoking != null ? invoking.strip() : "";
        final Method method = this.registereMethods.get(definition.getInstanceType()).get(invoking);
        if (method == null) {
            LOGGER.atTrace().log("Method {} not found", (Object)invoking);
            return null;
        }
        return new ResolvedInstanceType(){

            @Override
            public Method getMethod() {
                return method;
            }

            @Override
            public Class<?> getInstanceType() {
                return definition.getInstanceType();
            }

            @Override
            public InstanceScope getScope() {
                return definition.getInstanceScope();
            }

            @Override
            public InvocationModel getInvocationModel() {
                return definition.getInvocationModel();
            }
        };
    }

    public static DefaultInvokableResolver registeryFrom(Set<String> scanPackages) {
        return new DefaultInvokableResolver().register(DefaultInvokableResolver.perform(scanPackages).stream());
    }

    private static Set<InvokableDefinition> perform(Set<String> scanPackages) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return beanDefinition.getMetadata().isIndependent() || beanDefinition.getMetadata().isInterface();
            }
        };
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ForJms.class));
        return StreamOf.nonNull(scanPackages).map(arg_0 -> (scanner).findCandidateComponents(arg_0)).flatMap(Collection::stream).map(bean -> {
            try {
                LOGGER.atTrace().log("Scanning {}", (Object)bean.getBeanClassName());
                return Class.forName(bean.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.atError().log("This should not happen.", (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).map(type -> DefaultInvokableResolver.newDefinition(type)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static InvokableDefinition newDefinition(final Class<?> instanceType) {
        final ForJms annotation = instanceType.getAnnotation(ForJms.class);
        if (annotation == null) {
            return null;
        }
        if (Modifier.isAbstract(instanceType.getModifiers()) && annotation.scope().equals((Object)InstanceScope.MESSAGE) || instanceType.isEnum()) {
            throw new RuntimeException("Un-instantiable type " + instanceType.getName());
        }
        final HashMap<String, Method> invokings = new HashMap<String, Method>();
        ReflectingType reflected = new ReflectingType(instanceType);
        for (Method method : reflected.findMethods(Invoking.class)) {
            String invokingName = method.getAnnotation(Invoking.class).value().strip();
            if (invokings.containsKey(invokingName)) {
                throw new RuntimeException("Duplicate invocation methods: " + ((Method)invokings.get(invokingName)).toString() + ", " + method.toString());
            }
            invokings.put(invokingName, method);
        }
        if (invokings.get("") == null) {
            throw new RuntimeException("No invocation method defined by " + instanceType.getName());
        }
        final String msgType = Optional.of(annotation.value().strip()).filter(OneUtil::hasValue).orElseGet(instanceType::getSimpleName);
        LOGGER.atTrace().log("Registering {} on {}", (Object)msgType, (Object)instanceType.getCanonicalName());
        return new InvokableDefinition(){
            private final Map<String, Method> methods;
            {
                this.methods = Map.copyOf(invokings);
            }

            @Override
            public String getMsgType() {
                return msgType;
            }

            @Override
            public Class<?> getInstanceType() {
                return instanceType;
            }

            @Override
            public Map<String, Method> getMethods() {
                return this.methods;
            }

            @Override
            public InstanceScope getInstanceScope() {
                return annotation.scope();
            }

            @Override
            public InvocationModel getInvocationModel() {
                return annotation.invocation();
            }
        };
    }
}

