/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.time.Duration;
import java.util.Map;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.annotation.EnableByJms;
import me.ehp246.aufjms.api.dispatch.DispatchConfig;
import me.ehp246.aufjms.api.jms.AtDestination;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.core.dispatch.ByJmsFactory;
import me.ehp246.aufjms.core.reflection.EnabledScanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public final class ByJmsRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger LOGGER = LogManager.getLogger(ByJmsRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        LOGGER.atTrace().log("Scanning for {}", (Object)ByJms.class.getCanonicalName());
        new EnabledScanner(EnableByJms.class, ByJms.class, metadata).perform().forEach(beanDefinition -> {
            Class<?> proxyInterface;
            try {
                proxyInterface = Class.forName(beanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException ignored) {
                throw new RuntimeException("Class scanning started this. Should not happen.");
            }
            LOGGER.atTrace().log("Defining {}", (Object)beanDefinition.getBeanClassName());
            String name = proxyInterface.getAnnotation(ByJms.class).name();
            registry.registerBeanDefinition(name.equals("") ? proxyInterface.getSimpleName() : name, this.getProxyBeanDefinition(metadata.getAnnotationAttributes(EnableByJms.class.getCanonicalName()), proxyInterface));
        });
    }

    private BeanDefinition getProxyBeanDefinition(Map<String, Object> map, Class<?> proxyInterface) {
        final ByJms byJms = proxyInterface.getAnnotation(ByJms.class);
        AtDestination replyTo = new AtDestination(){

            @Override
            public DestinationType type() {
                return byJms.replyTo().type();
            }

            @Override
            public String name() {
                return byJms.replyTo().value();
            }
        };
        AtDestination destination = new AtDestination(){

            @Override
            public DestinationType type() {
                return byJms.value().type();
            }

            @Override
            public String name() {
                return byJms.value().value();
            }
        };
        final String ttl = byJms.ttl().equals("") ? (map.get("ttl").toString().equals("") ? Duration.ZERO.toString() : map.get("ttl").toString()) : byJms.ttl();
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addGenericArgumentValue(proxyInterface);
        args.addGenericArgumentValue((Object)new DispatchConfig(){
            final /* synthetic */ 2 val$destination;
            final /* synthetic */ 1 val$replyTo;
            {
                this.val$destination = var3_3;
                this.val$replyTo = var4_4;
            }

            @Override
            public String ttl() {
                return ttl;
            }

            @Override
            public AtDestination destination() {
                return this.val$destination;
            }

            @Override
            public AtDestination replyTo() {
                return this.val$replyTo;
            }
        });
        GenericBeanDefinition proxyBeanDefinition = new GenericBeanDefinition();
        proxyBeanDefinition.setBeanClass(proxyInterface);
        proxyBeanDefinition.setConstructorArgumentValues(args);
        proxyBeanDefinition.setFactoryBeanName(ByJmsFactory.class.getName());
        proxyBeanDefinition.setFactoryMethodName("newInstance");
        return proxyBeanDefinition;
    }
}

